# Chapter 0：数学基础
## 0.1 函数运算
### 0.1.1 三角函数
**`secx` 与 `cscx`**
+ 值域：$(-\infty,-1]\cup[1,+\infty)$
+ 值：用 $\cos x$ 和 $\sin x$ 的倒数来算就可以
+ 图像：
	+ ![[Pasted image 20240528170409.png]]
	+ ![[Pasted image 20240528170424.png]]

**反三角函数**
+ 概念：
	+ 注意： 
		+ 反正弦函数并不是 $y=\sin x$ 在整个定义域上的反函数，注意 $y=\arctan x$ 的值域；
		+ 它仅是 $y=\sin x$ 在 $\left[-\frac\pi2,\frac\pi2\right]$ 上的反函数，其他区间的反函数求解需要通过恒等变形平移到 $\left[-\frac\pi2,\frac\pi2\right]$ 上才能表示，反余弦函数类似；
	+ 关系：`arcsinx` 与 `sinx`
		+ 在 $\left[-\frac\pi2,\frac\pi2\right]$ 时，由反函数 $f^{-1}[f(x)]=x$ 可知：$arc\sin(\sin x)=x$
		+ 在 $\left[-\frac\pi2,\frac\pi2\right]$ 时，由反函数 $f[f^{-1}(x)]=x$ 可知：$\sin(\arcsin x)\equiv x$
	+ 举例：利用恒等变换平移 x：
		+ 求 $\arcsin (\sin x),x\in(\frac{3}{4}\pi,\pi)$
		+ 构造 $\sin x = \sin(\pi-x)$，将区间移动至 $(\frac{1}{4}\pi,0)$，此时才可以使用复合函数
		+ 得到 $$\arcsin (\sin x)=\arcsin(\sin(\pi-x))=\pi-x, x\in (\frac{3}{4}\pi,\pi)$$
+ `arcsinx`：
	+ 值域：$\left[-\frac{\pi}{2},\frac{\pi}{2}\right]$
	+ ![[Pasted image 20240528170558.png]]
+ `arccosx`：
	+ 值域：$[0,\pi]$
	+ ![[Pasted image 20240528170623.png]]

**补充：$\arctan$ 的定义**
+ $\tan(\arctan x)= x$
+ 图示
	+ ![[Pasted image 20240301003959.png]]
+ 表格
	+ ![[Pasted image 20240301004243.png]]

**三角函数基础**
+ 和差公式：
	+ 公式：
		+ $$\begin{aligned}&\sin\left(x\pm y\right)=\sin x\cos y\pm\cos x\sin y\\&\cos\left(x\pm y\right)=\cos x\cos y\mp\sin x\sin y\\&\tan\left(x\pm y\right)=\frac{\tan x\pm\tan y}{1\mp\tan x\tan y}.\end{aligned}$$
	+ 常用结论：
		+ $$\sin x+\cos x=\sin(x+\frac{{\pi}}{4})$$
		+ $$\sin(n\pi+\alpha)=(-1)^n\sin\alpha$$
	+ 诱导公式： 
		+ ![[Pasted image 20240825180254.png]]
+ 倒数关系：
	+ $$\tan\alpha\cot\alpha=1、\sin\alpha\csc\alpha=1、\cos\alpha\sec\alpha=1$$
+ 商数关系： 
	+ $$\tan\alpha=\frac{\sin\alpha}{\cos\alpha}、\cot\alpha=\frac{\cos\alpha}{\sin\alpha}$$
+ 平方关系：
	+ $$ \sin^{2}\alpha+\cos^{2}\alpha=1、1+\tan^{2}\alpha=\sec^{2}\alpha、1+\cot^{2}\alpha=\csc^{2}\alpha$$
+ 二倍角公式：
	+ $$\sin2\alpha=2\sin\alpha\cos\alpha$$
	+ $$\cos2\alpha=\cos^2\alpha-\sin^2\alpha=2\cos^2\alpha-1=1-2\sin^2\alpha$$
	+ $$\tan2\alpha=\frac{2\tan\alpha}{1-\tan^2\alpha}=\frac{2\cot\alpha}{\cot^2\alpha-1}=\frac{2}{\cot\alpha-\tan\alpha}$$
+ 半角公式：
	+ $$\begin{aligned}
&\sin{\frac{\alpha}{2}}=\pm{\sqrt{\frac{1-\cos\alpha}{2}}} \\
&\cos{\frac{\alpha}{2}}=\pm\sqrt{\frac{1+\cos\alpha}{2}} \\
&\tan{\frac{\alpha}{2}}={\frac{\sin\alpha}{1+\cos\alpha}}={\frac{1-\cos\alpha}{\sin\alpha}}=\pm{\sqrt{\frac{1-\cos\alpha}{1+\cos\alpha}}} \\
&\cot{\frac{\alpha}{2}}={\frac{1+\cos\alpha}{\sin\alpha}}={\frac{\sin\alpha}{1-\cos\alpha}}=\pm{\sqrt{\frac{1+\cos\alpha}{1-\cos\alpha}}}
\end{aligned}$$
+ 降次与升次 
	+ 降次公式：
		+ $$\cos^{2}\alpha=\frac{1+\cos2\alpha}{2},\sin^{2}\alpha=\frac{1-\cos2\alpha}{2},tan^2\alpha=\frac{1-cos2\alpha}{1+cos2\alpha}$$
	+ 升次公式： 
		+ $$1+\cos2\alpha=2\cos^2\alpha,1-\cos2\alpha=2\sin^2\alpha, 1\pm\sin2\alpha=\left(\sin\alpha\pm\cos\alpha\right)^2$$
	+ $\cos x$ 的消 $1$ 特性：
		+ 举例：$$1-\cos x=1-(\cos 2*\frac{x}{2})=1-(1-2\sin^2 \frac{x}{2})=2\sin^2 \frac{x}{2}$$
+ 反三角函数：
	+ $$x=a\sin t { 时}，t=\arcsin\frac xa.$$
	+ $$\text{x=a sect}时,t=\mathrm{arc}\cos\frac{a}{x}$$

**三角函数求导合集**
+ 正弦、余弦：
	+ $$(\sin x)^{\prime}=\cos x、(\cos x)^{\prime}=-\sin x$$
+ `tan、cot、sec、csc`： 
	+ $$\begin{aligned}(\tan x)^{\prime}&=\sec^2x&(\cot x)^{\prime}&=-\csc^2x\\\\(\sec x)^{\prime}&=\sec x\tan x&(\csc x)^{\prime}&=-\csc x\cot x\end{aligned}$$
+ 反三角函数：
	+ $$\begin{aligned}&(\arcsin x)^{\prime}=\frac1{\sqrt{1-x^2}}&&(\arccos x)^{\prime}=-\frac1{\sqrt{1-x^2}}\\&(\arctan x)^{\prime}=\frac1{1+x^2}&&(arccot x)^{\prime}=-\frac1{1+x^2}\end{aligned}$$

### 0.1.2 极坐标
**极坐标基础概念**
+ 转换：
	+ $$\left\{\begin{array}{c}x=r\mathrm{cos}\theta\\y=r\mathrm{sin}\theta\end{array}\right.\Leftrightarrow\left\{\begin{array}{c}r=\sqrt{x^2+y^2}\\\theta=\arcsin\frac yr=\arcsin\frac y{x^2+y^2}\end{array}\right.$$
	+ 注意：上述转换方法仅限于二者圆点相同，且极坐标参考系与直角坐标的 𝑥 轴方向相同的情况；

**极坐标常见函数形式**
+ 射线 `y=kx` ，其极坐标方程：$\theta=\theta_0$
+ 圆心在原点，半径为 `a` 的圆：$r=a$
+ 圆心在 `(a,0)` 点，半径为 `a` 的圆：$r=2a\cos\theta$
+ 圆心在 `(0,a)` 点，半径为 `a` 的圆：$r=2a\sin\theta$

### 0.1.3 参数方程
**参数方程**
+ 直线：
	+ 形式：
		+ $y=k(x-x_{0})+y_{0}$
	+ 参数方程：
		+ $\begin{cases}x=x_0+t\cos\alpha\\y=y_0+t\sin\alpha\end{cases}$
	+ 图示：
		+ ![[Pasted image 20240531042042.png]]
+ 圆：
	+ 形式：
		+ $(x-a)^2+(y-b)^2=r^2$
	+ 参数方程： 
		+ $\begin{cases}x=a+r\cos t\\y=b+r\sin t\end{cases}$
	+ 图示：
		+ ![[Pasted image 20240531042219.png]]

**初等数学常见参数方程**
$$
\begin{aligned}
&\text{圆:} \left\{\begin{array}{l}x=r\cos t\\y=r\sin t\end{array}\right. \\
&\text{椭圆:}\begin{cases}x=a\cos t\\y=b\sin t&\end{cases} \\
&\text{双曲线:}\left\{\begin{array}{l}x=a\sec t\\y=b\tan t\end{array}\right. \\
&\text{一} \text{抛物线:}\left\{\begin{array}{l}x=2ct\\y=t^2\end{array}\right. \\
&\text{螺线:} \left\{\begin{matrix}x=t\cos lt\\y=t\sin lt\end{matrix}\right. \\
&\text{摆线:} \left\{\begin{array}{l}x=r\cdot(t-\sin t)\\y=r\cdot(1-\cos t)\end{array}\right. 
\end{aligned}
$$

**常见参数方程及其图形**
+ 星形线 
	+ 一般式 $$x^{\frac23}+y^{\frac23}=a^{\frac23}$$
	+ 参数方程 $$\begin{cases}x=a\cos^3\theta\\y=a\sin^3\theta\end{cases}$$
	+ 图像： 
		+ ![[Pasted image 20240825155755.png]]
+ 摆线 
	+ $$\text{参数方程 }\begin{cases}x=a (\theta-\sin\theta)\\y=a (1-\cos\theta)\end{cases}.$$
	+ ![[Pasted image 20240825155730.png]]
+ 对数螺纹线： 
	+ $$\rho=a\mathrm{e}^{\theta}$$
	+ ![[Pasted image 20240825155838.png]]
+ 双扭线
	+ ![[Pasted image 20240825155711.png]]

### 0.1.4 对数与指数
**对数运算法则**
+ $$log_a(mn)=log_am+log_an$$
	+ 注意：$\log_2{(m+n)}不能拆开为(\log_2m)*(\log_2n)$，只能进行上面的运算，两者不要弄混了；
+ $$log_am^n=nlog_am$$
+ $$log_a\left(\frac{m}{n}\right)=log_am-log_an$$
+ $$log_a\sqrt[n]{m}=\frac{1}{n}log_am$$
+ $$\log_ab=\frac{\log_cb}{\log_ca}$$
+ $$u^v=\mathrm{e}^{v\ln u}\left(u>0\right)$$


**指数运算法则**
+ $$\begin{gathered}
a^{0}=1\left(a\neq0\right) \quad\quad\quad\quad a^{r}\cdot a^{s}=a^{r+s} \\
(a^{r})^{s}=a^{rs} \quad\quad\quad\quad \frac{a^{r}}{a^{s}}=a^{r-s}(a\neq0) \\
\left(ab\right)^{r}=a^{r}b^{r} \quad\quad\quad\quad a^{-r}=\frac{1}{a^{r}}(a\neq0) 
\end{gathered}$$

**对数与指数运算**
+ 等式两边同时取对数：
	+ 作用：同时取对数，消掉指数，得对数
	+ $$y=(x+1)^{3}(x-2)^{2}\rightarrow lny=3ln(x+1)+2ln(x-2)$$
+ 等式两边同时取指数：
	+ 作用：同时取指数，消掉对数，得指数
	+ $$y=\ln\left(x+{\sqrt{x^{2}+1}}\right)\rightarrow e^y=x+\sqrt{x^2+1}$$

### 0.1.5 初等函数
**平方、立方、多项公式**
+ 三项之和平方差：
	+ $$\left(a+b+c\right)^2=a^2+b^2+c^2+2ab+2ac+2bc$$
+ 完全立方和、差：
	+ $$\begin{aligned}\left(a+b\right)^3&=a^3+b^3+3a^2b+3ab^2\\\left(a-b\right)^3&=a^3-b^3-3a^2b+3ab^2\end{aligned}$$
+ 二项式定理：
	+ $$\begin{aligned}&\left(a+b\right)^{n}=\sum_{k=0}^{n}\mathrm{C}_{n}^{k}a^{n-k}b^{k}=a^n+\mathrm{C}_n^1a^{n-1}b+\cdots+\mathrm{C}_n^{n-1}ab^{n-1}+b^n\end{aligned}$$

**分子、分母有理化**
+ 有理化 `->` 去除掉分子或者分母中的根式
+ 分子有理化：
	+ 将分子分母同乘以其分子中根式的共轭根式；
	+ 举例：$$f(x)=\frac{\sqrt{x+1}-\sqrt{x-1}}{x}=\frac{(\sqrt{x+1}-\sqrt{x-1})*(\sqrt{x+1}+\sqrt{x-1})}{x(\sqrt{x+1}+\sqrt{x-1})}=\frac{2}{x\cdot(\sqrt{x+1}+\sqrt{x-1})}$$
	+ 其中 $\sqrt{x+1}+\sqrt{x-1}$ 是 $\sqrt{x+1}+\sqrt{x-1}$ 的共轭根式；
+ 分母有理化： 
	+ 方法同分子有理化，将分子分母同乘其分母的共轭根式；
+ 分子分母有理化： 
	+ 分子、分母先同乘分子的根式的共轭根式，然后再同乘分母的共轭根式；

**裂项**
+ 方法： 
	+ 第一步：设拆项后的分式以及 A、b 
	+ 第二步：将带有 A、B 的式子同分，分子中带 A、B 的式子变换成标准式
	+ 第三步：将带 A、B 的标准式和原式子中分子对比，系数相等，解出 A、b  
+ 举例： 
	+ $$求\quad\frac{x}{x^2-5x+6}$$
	+ $$已知\frac{x}{x^2-5x+6}=\frac{x}{(x-2)(x-3)}，设\frac{A}{x-2}+\frac{B}{x-3}$$
	+ 通分，得到：$$\frac{\text{A}(x-3)+\text{B}(x-2)}{(x-2)(x-3)}=\frac{(\text{A+B})x-3\text{A}-2\text{B}}{(x-2)(x-3)}$$
	+ 对比系数 `x`，得到：$$\left.\left\{\begin{array}{c}\left(1\right)\mathrm{A}+\mathrm{B}=1\\\left(2\right)\mathrm{3A}+2\mathrm{B}=0\end{array}\right.\right.$$
	+ 可得：`B=3, 则 A=2`，即：$$\frac{2}{x-2}+\frac{3}{x-3}$$
+ 举例 2：
	+ ![[Pasted image 20241127124659.png]]

**加项、减项、拆**
+ 目的：
	+ 进行多项式分式的化简；
+ 方法：
	+ 从分子的最高项开始入手，去**凑**与分母相同的**公因式**进行相消，随后**依次逐个**从高到低进行化简，直至化到**分子最高项小于分母**；

**一元二次方程**
+ 对 $ax^2+bx+c=0\left(a\neq0\right)$：
	+ $\triangle = b^2- 4ac> 0\Leftrightarrow$ 方程有两个不同的实根；
	+ $\triangle = b^2- 4ac= 0\Leftrightarrow$ 方程有两个相等实根；
	+ $\bigtriangleup=b^2-4ac<0\Leftrightarrow$ 方程有一对共轭复根
+ 求根公式：
	+ $$x_{1,2}=\frac{-b\pm\sqrt{b^2-4ac}}{2a}$$

**求解三次方程**
+ 第一步：将方程改写成 $x^3+bx^2+cx+d=0$ 的形式；  
+ 第二步：猜根，根据 `d` 猜测其可以分解成哪三个数的乘积；
+ 第三步：整理，分解因式 `->` 先将其整理成 $(x-x_0)\left(x^2+px+q\right)=0$ 的形式，求解 $x^2+px+q=0$ 得到另外两个根；

**结论**
+ 反正切函数： 
	+ $$\arctan x+\arctan\frac1x\equiv\frac\pi2(x>0).$$
+ 下面指数直接写值：
	+ $$(-1)^{2n}=1\quad\quad(-1)^{2n-1}=-1$$
	+ $$n\to\infty时,\quad(-1)^{n-3}=(-1)^{n-1}$$
	+ $$x^n-1=(x-1)(x^{n-1}+x^{n-2}+\cdots+x+1)$$

## 0.2 几何基础
### 0.2.1 直线
**直线常用形式**
+ 点斜式：$$y-y_0=k\left(x-x_0\right)$$
+ 两点式：$$y-y_1=\frac{y_2-y_1}{x_2-x_1}\left(x-x_1\right)\rightarrow \frac{y-y_1}{y_2-y_1}=\frac{x-x_1}{x_2-x_1}.$$
+ 标准式：$$Ax+By+C=0$$  

**点到直线距离公式**
+ 距离公式：
	+ $$d=\frac{|Ax_1+By_1+C|}{\sqrt{A^2+B^2}}$$

**法线、切线**
+ 切线方程：$y-y_{0}=f^{\prime}(x_{0})(x-x_{0})$
+ 法线方程：$y-y_0=-\frac1{f^{\prime}(x_0)}(x-x_0)$

### 0.2.2 圆与椭圆
**圆及其标准形式**
+ 标准形式：$$(x-a)^2+(y-b)^2=R^2$$
+ 周长：$$2\pi R$$
+ 面积：$$\pi R^2$$ 
+ 圆的表面积：$$S=4\pi R^2$$
+ 圆的体积公式：$$\frac{4}{3}\pi R^3$$

**圆锥的体积**
+ S 为圆锥的底面积，H 为圆锥的高，则：
+ $$S_{圆锥}=\frac{1}{3}SH$$
+ 若圆锥底面的半径为 R，则：
+ $$S_{圆锥}=\frac{\pi}{3} R^2H$$

**椭圆及其面积**
+ 椭圆方程： $$\frac{x^2}{a^2}+\frac{y^2}{b^2}=1$$
+ 偏心椭圆方程： 
	+ x 轴平移 m，沿 y 轴平移 n 
	+ $$\frac{\left(x-m\right)^2}{a^2}+\frac{\left(y-n\right)^2}{b^2}=1$$
+ 椭圆面积：$$S=\pi ab$$

### 0.2.3 三角形面积
**概念**：三角形的两个面积公式
+ 设 `x、y、z` 是三角形的两个边，并且 `y` 为三角形的底边，`h` 为三角形的高，三角形的周长为 `2p`
+ $$S=\sqrt{p(p-x)(p-y)(p-z)}=\frac12yh$$

### 0.2.4 体积
**概念**
+ 四面体体积： 
	+ $$V_{四面体}=\frac{1}{3}S_{底面积}*高$$

## 0.3 数列与数学归纳法
### 0.3.1 数列求和
**等差与等比数列**
+ 等差数列求和：$$s_n=\frac{(a_1+a_n)n}{2}$$
+ 等比数列求和：$$s_n=\begin{cases}na_1,\quad(q=1),\\\frac{a_1(1-q^n)}{1-q},\quad(q\neq1).\end{cases}$$

**常用求和结论**
+ $$\sum_{k=1}^{1}\frac{1}{4k^{2}-1}=\frac{1}{2}\sum_{k=1}^{n}(\frac{1}{2k-1}-\frac{1}{2k+1})=\frac{1}{2}(1-\frac{1}{2k+1})$$
+ $$\sum_{k=1}^{n}k=\frac{1}{2}n(n+1)$$
+ $$\sum_{k=1}^{n}k^{2}=\frac{1}{6}n(n+1)(2n+1)$$

### 0.3.2 数学归纳法 
**第一数学归纳法**
+ 第一数学归纳法适合于递推式只涉及到 $a_1$ 和 $a_n$ 两项的命题，其步骤为：
+ （1）验证 `n=1` 时命题正确；
	+ 将 `n=1` 代入等式左右两边，看是否成立；
+ （2）假设 `n=k` 时命题正确；
	+ 自己设一个任意数 `k`，并且假设现在这个 `k` 就是 `n`，代入到式子左右两边；
+ （3）证明 `n=k+1` 时命题正确
	+ 取 `n=k+1`，将其代入式子左边（求和式）与右边，将其整理为 `n=k+1` 的等式形式；

**第二数学归纳法**
+ 举例： 
	+ 设 $D_n= 2aD_{n- 1}- a^{2}D_{n- 2}$ , $D_{1}= 2a$, $D_2=3a^2\left(a\neq0\right)$,利用数学归纳法证明：$D_n=\left(n+1\right)a^n.$
+ 第二数学归纳法适合于递推式涉及到 $a_{n-1}$，$a_n$ 和 $a_{n+1}$ 三项的命题，其步骤为：
+ （1）验证 `n=1` 和 `n=2` 时命题正确; 
	+ 当 $n=1$ 时 $D_1=2a=\left(1+1\right)a^{1}$,
	+ 当 $n=2$ 时，$D_2= ( 2+ 1) a^2$,命题成立，
+ （2）假设 `n<k` 时命题正确；
	+ $\text{设}n<k\text{时, 有}D_n=\left (n+1\right) a^n\text{成立}$
+ （3）证明 `n=k` 时命题正确；
	+ 则当 `n=k` 时，$\begin{aligned}&D_k=2aD_{k-1}-a^2D_{k-2}=2a\left(ka^{k-1}\right)-a^2\left[\left(k-1\right)a^{k-2}\right]\end{aligned}=\begin{pmatrix}k+1\end{pmatrix}a^k.$
	+ 由数学归纳法可知其成立；

## 0.4 其他知识
### 0.4.1 复数
**概念**
+ 复数：$\text{对任意两实数x,y,称 z=x+iy 或 z=x+yi 为复数}$
+ 运算：$$i^2=-1\quad i=\sqrt{-1}\quad\text{i 称为虚部}$$
+ 举例：$\sqrt{-4}=2\sqrt{-1}=2i$

### 0.4.2 物理应用

### 0.4.3 常用不等式
**基本不等式**
+ 乘法、开方原则：  
	+ $$(\text{乘方法则})a>b>0\Rightarrow a^{n}>b^{n}(n\in N,\text{且}n>1) ;$$
	+ $$\\(\text{开方法则})a>b>0\Rightarrow\sqrt[n]{a}>\sqrt[n]{b}(n\in N,\text{且}n>1)$$
+ 基本不等式： 
	+ $$a^2+b^2\geq2ab，当且仅当a=b时取等号$$
	+ $$\frac{a+b+c}3\geq\sqrt[3]{abc} (a,b,c\in R^+)$$

**高数常用不等式**
+ 绝对值不等式： 
	+ $$-|x|\leqslant x\leqslant|x|$$
	+ $$|a|-|b|\leq|a\pm b|\leq|a|+|b|$$
	+ $$|\sin x|\leqslant1$$
+ 常用其他不等式： 
	+ $$\begin{aligned}&(1) \left|\sin x\right|\leqslant\left|x\right|, \forall x\in R , \text{当}x=0 \text{时取等号};\\&(2) \left|x\right|\leqslant\left|\tan x\right|, \forall x\in\left(-\frac{\pi}{2},\frac{\pi}{2}\right), \text{当}x=0 \text{时取等号};\\&(3) \frac{x}{1+x}\leqslant\ln\left(1+x\right)\leqslant x , \forall x\geqslant0 ;\end{aligned}$$
	+ $$\ln n<\sqrt n$$
+ 积分不等式： 
	+ $$f(x){\leqslant}g(x)\text{,则}\int_a^bf(x)dx{\leqslant}\int_a^bg(x)dx .$$
	+ $$\left|\int_a^bf(x)dx\right|\leqslant\int_a^b\left|f(x)\right|dx(a<b)$$
	+ $\text{ 设}M\text{ 及}m\text{ 分别是函数}f(x)\text{在区间}[a,b]\text{上的最大值和最小值,则:}$
		+ $$\\m(b-a)\leqslant\int_a^bf(x)dx\leqslant M(b-a)(a<b)\text{(积分估值定理)}$$

# Chapter 1：函数、极限、连续
## 1.1 函数基础性质
**基本初等函数**
+ 幂函数、指数、对数、三角函数、反三角函数； 

**初等函数**
+ 1. 常数和五类基本初等函数构成；
+ 2. 进行的加减乘除以及复合；
+ 3. 所得到的用一个解析式表达的函数；

**反函数与复合函数**
+ 情况一： $f^{-1}[f(x)]=x$
+ 情况二： $f[f^{-1}(x)]=x$

**奇偶性**
+ 奇偶判断： 
	+ 常见奇函数：$\sin x,\tan x,\arcsin x,\arctan x,\ln\frac{1-x}{1+x},{\ln(x+\sqrt{1+x^2})},\frac{e^x-1}{e^x+1},$$f(-x)=-f(x)$
	+ 常见偶函数：$x^2,|x|,\cos x,f(x)=f(-x)$
+ 运算规则：
	+ 奇函数 + 奇函数 = **奇函数** 
	+ 偶函数 + 偶函数 = 偶函数 
	+ 奇函数 + 偶函数 = **非奇非偶**
	+ 奇函数 × 奇函数 = **偶函数** 
	+ 偶函数 × 偶函数 = 偶函数 
	+ 奇函数 × 偶函数 = 奇函数 
+ 复合函数：
	+ 内奇外同，内偶则偶
	+ 内函数是奇函数，则复合函数得奇偶性和外函数相同；
	+ 内函数是偶函数，则复合函数是偶函数；
+ 导数关系：
	+ 奇函数的导函数：偶函数；
	+ 偶函数的导函数：奇函数；

**周期性**
+ 1.  $\sin x,\cos x\text周期为2\pi；\sin2x,|\sin x|\text周期为\pi$
+ 2. $\text{若}f(x)\textit{以}T\text为周期,则f(a\text{x}+b)\textit{ 以}\frac T{|a|}\text{为周期}.$

## 1.2 极限、连续
**无穷小**
+ **同阶**无穷小： $\alpha(x)和\beta(x)$ 相除结果为**常数 C**（C 不等于 0）；
+ **等价**无穷小： $\alpha(x)和\beta(x)$ 相除结果为**常数 1**；
+ 高阶无穷小： $\alpha(x)和\beta(x)$ 相除结果为 0；可记为：$\alpha(x)=o(\beta(x))$
+ 低阶无穷小： $\alpha(x)和\beta(x)$ 相除结果为无穷；
+ $$\text{若}\lim\frac{\alpha (x)^{\color{red}{}}}{\left[\beta (x)\right]^{k}\color{red}}=C\neq 0,\text{称α为β的 k 阶无穷小；}$$ 

**连续性**
+ 定义：
	+ 定义 1：$\text{若 }\lim_{\Delta x\to0}\Delta y=\lim_{\Delta x\to0}[f(x_0+\Delta x)-f(x_0)]=0，则称y=f(x)在x_0点连续$ 
	+ 定义 2：设函数 $y=f(x)$ 在点 $x_{0}$ 的某个邻域内有定义，如果当 $x\to x_0$ 时，函数 $y=f(x)$ 的极限值存在，且等于 $x_{0}$ 处的函数值 $f(x_0)$ , 即 $\lim_{x\to x_0}f(x)=f(x_0)$, 则称函数 $y=f(x)$ 在点 $x_{0}$ 处连续.
+ $f(x)$ 连续的充分必要条件：$f(x)$ **左连续且右连续**，**左右连续相等**；

**间断点**
+ 1. 第一类间断点：左, 右极限均存在；
	+ 可去间断点：且左极限=右极限；
	+ 跳跃间断点：左极限不等于右极限；
+ 2. 第二类间断点：左、右极限中**至少有**一个不存在；
	+ 无穷间断点：比如 $1/x$ 中，当 x=0 时；
	+ 振荡间断点：比如在 x 趋向于 0 时，$sin1/x$ 为振荡间断点；
	+ 无穷和震荡是第二类当中常见的两种，但是不一定只有这两种，也可能既不是无穷、也不是震荡；
+ 常见需分左右极限情况：
	+ 1. 分段函数分界点；
	+ 2. E 无穷：$e^{\infty}$；
	+ 3. Arctan 无穷；

## 1.3 求极限的方法
### 1.3.1 利用基本极限求极限
**常用基本极限**
+ $$\lim_{x\to0}\frac{\sin x}x=1;$$

**幂指数与根号**
+ $$\lim_{x\to0}(1+x)^{\frac1x}=e;$$
	+ 是 $1^\infty$ 型，且括号内的幂底数是大于 0 的；
	+ $\lim_{x\to0}(1+\frac{1}{x})^{x}$ 不存在，因为 x 趋向于 0 时，还可以是趋向于 0 负；
	+ 易错点：注意以下极限不等于 `a`；  $$\lim_{n\to \infty} a(\frac{n}{{n+1}})^n=\frac{a}{e}$$
+ $\lim_{x\to0^+}(1+\frac{1}{x})^{x}=1$ 
+ $\lim_{x\to\infty}(1+\frac1x)^x=e;$
	+ 是 $1^\infty$ 型，且括号内的幂底数是大于 0 的
	+ $\lim_{x\to\infty}(1+x)^{\frac{1}{x}}$
+ $\lim_{x\to+\infty}(1+x)^{\frac{1}{x}}=1$ 
+ $\lim_{x\to0}\frac{a^x-1}x=\ln a;$
+ $\lim_{n\to\infty}\sqrt[n]{n}=1.$
	+ 注意这里是 n ，所以是趋向于正无穷；
+ $\lim_{n\to\infty}\sqrt[n]{a}=1,(a>0).$
	+ 注意这里是 n ，所以是趋向于正无穷；

**分段函数**
+ $\left.\lim_{{x\to\infty}}\frac{a_nx^n+a_{n-1}x^{n-1}+\cdots+a_1x+a_0}{{b}_mx^m+b_{m-1}x^{m-1}+\cdots+b_1x+b_0}=\left|\begin{array}{ll}\frac{a_n}{b_m},&n=m,\\0,&n<m,\\\infty,&n>m.\end{array}\right.\right.$
	+ 分子分母这么多项，结果主要取决于最大的数（最高次数）；
	+ 注意 x 是趋向于无穷。
	+ 当 x 趋向于 0 时，此时函数的值应该取决于最小的数（最低次数）；
+ $\lim_{{n\to\infty}}x^n=\begin{cases}\begin{array}{c}\mathbf{0},&|x|<1,\\\infty,&{|x|>1}\\1,&{x=1}.\end{array}\\\text{不存在,}&x=-1.&\end{cases}$
+ $\lim_{n\to\infty}e^{{nx}}=\begin{cases}0,&x<0,\\+\infty,&x>0\\1,&x=0.&\end{cases}$

 **1 的无穷大次方**
+ 对 $1^{\infty}$ 而言，其结果是不定式，不一定等于 1；
+ $\text{若 }\lim\alpha(x)=0,\lim\beta(x)=\infty,\text{ 且 }\lim\alpha(x)\beta(x)=A。\text{则 }\lim(1+\alpha(x))^{\beta(x)}=e^A$
	+ 即核心在 $\lim\alpha(x)\beta(x)=A$，看它是否成立；
+ 方法三部曲
	+ 1. 写成标准形式：$\text{原式 }=\mathbf{lim}[1+\alpha(x)]^{\beta(x)}$；
	+ 2. 求极限：$\lim\alpha(x)\beta(x)=A;$
	+ 3. 写结果：$\text{原式}=e^A.$

### 1.3.2 等价无穷小代换
**等价代换的原则**
+ 1. 乘除关系可以换
	+ $\text{若 }\alpha\sim\alpha_1,\beta\sim\beta_1,\text{则}\lim\frac\alpha\beta=\lim\frac{\alpha_1}\beta=\mathbf{lim}\frac\alpha{\beta_1}=\mathbf{lim}\frac{\alpha_1}{\beta_1}$
+ 2. 加减关系在**一定条件**下可以换
	+ 减法
		+ $\text{若 }\alpha{\sim}\alpha_1,\beta{\sim}\beta_1,\text{且 }\lim\frac{\alpha_1}{\beta_1}=A\neq1.\text{ 则 }\alpha{-}\beta{\sim}\alpha_1{-}\beta_1$
		+ 减法换的条件：**两个减法项不等价**，A 不等于 1；
		+ 比如：$sin2x - tanx$ ~ $2x - x$
	+ 加法
		+ $\text{若}\alpha{\sim}\alpha_1,\beta{\sim}\beta_1,\text{且 }\lim\frac{\alpha_1}{\beta_1}=A\neq-1.\text{ 则 }\alpha{-}\beta{\sim}\alpha_1{+}\beta_1$
		+ 减法换的条件：两个加法项不等价，A 不等于 -1；

**常用等价无穷小**
+ 当 x 趋向于 0 时；
+ ${(1+x)^\alpha-1}\sim{\alpha x}$
+ $e^{x}-1\sim x$
	+ 幂指函数的代换；
+ $$x\sim\sin x\sim\tan x\sim\arcsin x\sim\arctan x\sim\ln(1+x)\thicksim e^x-1;$$
	+ 变式：$\ln q(x)\sim q(x)-1,q(x)\to1$
+ $$a^x-1\sim x\ln a,\quad{(1+x)^\alpha-1\sim\alpha x},\quad1-\cos x\sim\frac12x^2$$

**高阶等价无穷小**
+ $x-\sin x\sim\frac16x^3$，$\tan x-x\sim\frac13x^3$
+ $\arcsin x-x\sim\frac16x^3\quad x-\arctan x\sim\frac13x^3$
+ $x-\ln(1+x)\sim\frac12x^2$ 

**两个等价无穷小的更通用形式**
+ $\log^{a}(1+2x)\sim(2x)^{a}=2^{a}x^{a}$
+ $(1-ax)^{\frac{1}{\alpha}}\sim(\frac{1}{2}x^{2})^{\frac{1}{\alpha}}$

### 1.3.3 有理运算法则计算极限
**计算前提**
+ 极限的加减乘除运算可以拆开来计算，前提是：**每个被拆开部分的极限需要存在**；

**运算规则**
+ 规则： 
	+ $$lim(f(x)\pm g(x))=\lim f(x)\pm\lim g(x) \\\quad\quad\quad\quad\quad\quad
lim(f(x)\cdot g(x))=\lim f(x)\cdot\lim g(x) \\\quad\quad\quad\quad\quad\quad
lim\left(\frac{f(x)}{g(x)}\right)=\frac{\lim f(x)}{\lim g(x)}\quad(B\neq0)
$$
+ 加法： 
	+ 存在 + 存在：可拆
	+ 存在 + 不存在：不可拆
	+ 不存在 + 不存在：不一定


**常用结论**
+ 1. $\lim f(x)=A\neq0\Rightarrow\lim f(x)g(x)=A\lim g(x);$
	+ 极限非零的因子的极限可以先求出来；
+ 2. $\lim\frac{f(x)}{g(x)}\text{ 存在,}\lim g(x)=0\Rightarrow\lim f(x)=0;$ 
+ 3. $\lim\frac{f(x)}{g(x)}=A\neq0,\lim f(x)=0\Rightarrow\lim g(x)=0;$ 

### 1.3.4 洛必达法则
**洛必达法则**
+ $$\lim_{x\to x_0}\frac{f(x)}{g(x)}=\lim_{x\to x_0}\frac{f^{\prime}(x)}{g^{\prime}(x)}$$

**使用前提**
+ 1. $\lim_{x\to x_0}f(x)=\lim_{x\to x_0}g(x)=0\left(\infty\right)$
+ 2. $f(x)\text{ 和 }g(x)\text{在 }x_0\text{的某去心邻域内可导},\text{且 }g^{\prime}(x)\neq0$
+ 3. $\lim_{x\to x_0}\frac{f^{\prime}(x)}{g^{\prime}(x)}\text{存在;}$
	+ 举例：如果条件是函数 f (x) 二阶可导，则使用洛必达法则最多用到一阶导数

**使用环境**
+ 种类：$$\frac00;\quad\frac\infty\infty,\quad0\cdot\infty;\quad\infty-\infty;\quad1^\infty;\quad\infty^0;\quad0^0$$
+ 解题思路：$\frac00,\frac\infty\infty\quad\Leftarrow\begin{cases}\quad ∞-∞\\0\cdot\infty\quad\Leftarrow\begin{cases}1^\infty\\\infty^0\\0^0&\end{cases}&\end{cases}$
+ 转换方法：
	+ $0\cdot\infty\quad$
		+ 思路：将 0 或者无穷当中一个放到上面（分子）`OR` 下面（分母）；
	+ $1^\infty;\quad\infty^0;\quad0^0$：
		+ 思路：这三种都得改写成 0 乘以无穷大；
		+ 方法： $[f(x)]^{g(x)}=e^{g(x)f(x)}$  -> 改写成 e 的形式；
		+ 核心：求 e 上面的相乘部分的无限；

### 1.3.5 泰勒公式
**常用泰勒公式**
+ $$\mathrm{e^x=\sum_{n=0}^\infty\frac1{n!}x^n=1+x+\frac1{2!}x^2+\cdots\in(-\infty,+\infty)}$$
+ $$\sin\mathrm{x=\sum_{n=0}^\infty\frac{(-1)^n}{(2n+1)!}x^{2n+1}=x-\frac1{3!}x^3+\frac1{5!}x^5+\cdots,x\in(-\infty,+\infty)}$$
+ $$\cos\mathrm{x=\sum_{n=0}^\infty\frac{(-1)^n}{(2n)!}x^{2n}=1-\frac1{2!}x^2+\frac1{4!}x^4+\cdots,x\in(-\infty,+\infty)}$$
+ $$\mathrm{ln(1+x)=\sum_{n=0}^\infty\frac{(-1)^n}{n+1}x^{n+1}=x-\frac12x^2+\frac13x^3+\cdots,x\in(-1,1]}$$
+ $$\begin{aligned}&\frac1{1-\mathrm{x}}=\sum_{\mathrm{n=0}}^\infty\mathrm{x^n}=1+\mathrm{x+x^2+x^3+\cdots,x\in(-1,1)}\\&\frac1{1+\mathrm{x}}=\sum_{\mathrm{n=0}}^\infty(-1)^\mathrm{n}\mathrm{x}^\mathrm{n}=1-\mathrm{x}+\mathrm{x}^2-\mathrm{x}^3+\cdots,\mathrm{x}\in(-1,1)\end{aligned}$$
+ $$\mathrm{(1+x)^a=1+\sum_{n=1}^\infty\frac{a(a-1)\cdots(a-n+1)}{n!}x^n=1+ax+\frac{a(a-1)}{2!}x^2+\cdots,x\in(-1,1)}$$

**泰勒公式-展开结论** 
+ 公式： 
	+ $$\begin{aligned}
&\sin x=x-\frac1{3!}x^3+o\left(x^3\right) \\
&\arcsin x=x+\frac16x^3+o\left(x^3\right) \\
&\tan x=x+\frac13x^3+o\left(x^3\right) \\
&\arctan x=x-\frac13x^3+o\left(x^3\right) \\
&\cos x=1-\frac1{2!}x^2+\frac1{4!}x^4+o\left(x^4\right) \\
&\mathrm{e}^x=1+x+\frac1{2!}x^2+\frac1{3!}x^3+o\left(x^3\right) \\
&\ln\left(1+x\right)=x-\frac12x^2+\frac13x^3+o\left(x^3\right) \\
&\begin{aligned}\left(1+x\right)^\alpha=1+\alpha x+\frac{\alpha\left(\alpha-1\right)}{2!}x^2+\end{aligned}\frac{\alpha(\alpha-1)(\alpha-2)}{3!}x^3+o\left(x^3\right)
\end{aligned}$$
+ 背诵技巧： 
	+ 解释： 
		+ 变：变符号，`+ - + - + -`
		+ 阶：阶乘，比如 `3`
	+ 口诀： 
		+ sin：变阶 135 
		+ cox：变阶 124 
		+ arcsin：正 13 带 6
		+ tanx：正 13
		+ arctanx：变 135 
		+ ex：阶乘 123
		+ In (1+x)：从 x 开始，变 123 


### 1.3.6 定积分定义
![[Pasted image 20241028004344.png]]

# Chapter 2：导数与微分
## 2.1 导数
**导数定义**
+ 定义：
	+ $\begin{aligned}\text{若 }&\lim_{\Delta x\to0}\frac{f(x_0+\Delta x)-f(x_0)}{\Delta x}&\text{存在，则称 }f(x)\text{ 在 }x_0\text{ 点可导}.\end{aligned}$
+ 另一种形式：
	+ $f^{\prime}(x_0)=\lim_{\Delta x\to0}\frac{f(x_0+\Delta x)-f(x_0)}{\Delta x}=\lim_{x\to x_0}\frac{f(x)-f(x_0)}{x-x_0}$
+ 形式一：$f^{\prime}(x_0)=\lim_{\Delta x\to0}\frac{f(x_0+\Delta x)-f(x_0)}{\Delta x}$
+ 形式二：$f^{\prime}(x_0)=\lim_{x\to x_0}\frac{f(x)-f(x_0)}{x-x_0}$

**左右导数**
+  左右导数的关系：可导 `<-->` **左右导数存在且相等**；

## 2.2 求导
### 2.2.1 方法一：和差积商求导法则
**有理运算法则**
设 $u(x),\nu(x)$ 都可导，则
+ $(u\pm v)^{\prime}=u^{\prime}\pm v^{\prime}$
+ $(uv)^{\prime}=u^{\prime}v+uv^{\prime}$
+ $(\frac\mu\nu)^{\prime}=\frac{\mu^{\prime}\nu-\nu^{\prime}\mu}{\nu^2}\quad(\nu\neq0)$

### 2.2.2 方法二：反函数求导法则
**反函数求导**
+ 公式：
	+ $$(f^{-1})^{\prime}(x)=\frac1{f^{\prime}(y)}\quad\frac{dy}{dx}=\frac1{dx}$$
+ 含义：
	+ 函数和反函数是两个函数，但是是同一条曲线；
	+ 因此**当函数连续且单调时，可以知其反函数也同样可导**；

### 2.2.3 方法三：复合函数求导法则
**链式法则**
+ 设 $u=g(x)$ 在 $x$ 可导，$y=f(u)$ 在对应 $u$ 处可导，则 $y=f[g(x)]$ 在 x 处可导。
+ 则： $\frac{dy}{dx}=f^{\prime}(u)g^{\prime}(x)$
+ 其他形式：
	+ $$\frac{dy}{dx}=\frac{dy}{du}\cdot\frac{du}{dx}$$


### 2.2.4 方法四：求导结论
**基本初等函数**
+ 基本
	+ $\begin{aligned}&\quad(C)^{\prime}=0\quad&\quad(x^\alpha)^{\prime}=\alpha x^{\alpha-1}\\&\quad(a^x)^{\prime}=a^x\ln a\quad&\quad(e^x)^{\prime}=e^x\\&\quad(\log_ax)^{\prime}=\frac1{x\ln a}\quad&\quad(\ln|x|)^{\prime}=\frac1x\end{aligned}$
+ 三角函数
	+ $(\sin x)^{\prime}=\cos x\quad\quad\quad\quad\quad(\cos x)^{\prime}=-\sin x$
	+ $\begin{aligned}(\tan x)^{\prime}&=\sec^2x&(\cot x)^{\prime}&=-\csc^2x\\\\(\sec x)^{\prime}&=\sec x\tan x&(\csc x)^{\prime}&=-\csc x\cot x\end{aligned}$
+ 反函数导数
	+ $\begin{aligned}&(\arcsin x)^{\prime}=\frac1{\sqrt{1-x^2}}&&(\arccos x)^{\prime}=-\frac1{\sqrt{1-x^2}}\\&(\arctan x)^{\prime}=\frac1{1+x^2}&&(\arctan x)^{\prime}=-\frac1{1+x^2}\end{aligned}$

### 2.2.5 方法五：对数求导法 
**例题**：$\text{设}y=\left(1+\sin x\right)^{x},\text{则}\mathrm{d}y|_{x=\pi}=$
+ 分析
	+ 这是幂指函数型，可以使用对数求导法；
+ 解析
	+ 先取对数：$\ln y=x\ln(1+\sin x)$
	+ 两边同时求导：$\frac{y^{\prime}}{y}=\ln(s+\sin x)+\frac{xCosx}{1+\sin x}$
	+ 提出 $y^{\prime}$，得到导函数
	+ 带入 x=Π；

**重要结论**
+ $(\ln|x|)^{\prime}=\frac{1}{x}$

**适用场合**
+ 1. 幂指型函数；
+ 2. 连乘、连除、乘法、开方；

## 2.3 高阶导数
**常见求 n 阶导数**
+ 指数
	+ $(e^{x})^{(n)}=e^{x}$
+ 三角函数
	+ $(\sin x)^{(n)}=\sin(x+n\frac\pi2)$
	+ $(\cos x)^{(n)}=\cos(x+n\frac{\pi}{2})$
+ `In` 函数
	+ $(\ln(1+x))^{(n)}=(-1)^{n-1}\frac{(n-1)!}{(1+x)^n}$
+ 加法
	+ $(u\pm v)^{(n)}=u^{(n)}\pm v^{(n)}$
+ 乘法
	+ 莱布尼茨公式
	+ ${(u\nu)^{(n)}}=\sum_{k=0}^nC_n^ku^{(k)}v^{(n-k)}$

## 2.4 微分
**微分定义**
+ $\text{若 }f(x_0+\Delta x)-f(x_0)=A\Delta x+o(\Delta x)\text{ ，则称 }f(x)$ $在 x _0点可微；$
+  $A\Delta x 称为 f(x)在 x_0 点的微分$
	+ 第一部分为函数变化的主要部分
	+ 第二部分为高阶无穷小，为次要部分

**可微、可导、连续之间关系**
![[Pasted image 20240317192744.png]]

## 2.5 泰勒公式  
**公式**：带 Peano 余项的泰勒公式 
+ $\text{设}f(x)\text{ 在 }x_0\text{ 处 }n\text{ 阶可微,则}$：
+ $$f(x)=\sum_{k=0}^n\frac{f^{(k)}(x_0)}{k!}(x-x_0)^k+o((x-x_0)^n)$$
+ $$f\left(x\right)=\frac{f\left(x_{0}\right)}{0!}+\frac{f^{\prime}\left(x_{0}\right)}{1!}(x-x_{0})+\frac{f^{\prime\prime}\left(x_{0}\right)}{2!}(x-x_{0})^{2}+\ldots+\frac{f^{\left(n\right)}\left(x_{0}\right)}{n!}(x-x_{0})^{n}+o((x-x_0)^n)$$
+ $$\text{用}n+1\text{阶导数表示的余项叫拉格朗日余项, 用}o\left (x^n\right)\text{或者}o\left (\left (x-x_0\right)^n\right)\text{表示的是Peano 余项 }$$

**公式**：带 `Peano` 余项的泰勒公式 - 零点的泰勒展开
+ $$\begin{gathered}\text{若 }x_0=0\text{ , 则} \\F (x)=f (0)+f^{\prime}(0) x+\frac{f^{\prime\prime}(0)}{2!}x^2+\cdots+\frac{f^{(n)}(0)}{n!}x^n+\frac{f^{(n+1)}(\theta x)}{(n+1)!}x^{n+1} \\上式称为  f (x)\text{ 的 Maclaurin 公式} \end{gathered}$$


**公式**：带有 `拉格朗日余项` 的泰勒公式  
+ 其中的 $\xi$ 位于 $x$ 到 $x_0$ 之间，因此
+ $$f(x)=f(a)+f^{\prime}(a)(x-a)+\frac{f^{\prime\prime}(a)}{2!}(x-a)^2+\cdots+\frac{f^{(n)}(a)}{n!}(x-a)^n+\frac{f^{(n+1)}(\xi)}{(n+1)!}(x-x_{0})^{n+1}$$

# Chapter 3：微分中值定理
## 3.1 三大定理
**罗尔定理**
+ 定义：
	+ 若满足三个条件：
	+ 1）$f$ 在 $[a,b]$ 上连续；
	+ 2）$f$ 在 $(a,b)$ 内可导；
	+ 3）f (a)=f (b)
	+ 则可知：$$\text{则 }\exists\xi\in(a,b)\text{,使 }f^{\prime}(\xi)=0$$
+ 图示：
	+ ![[Pasted image 20231225142739.png]]

**拉格朗日中值定理**
+ 定义：
	+ 若满足以下几个条件：
	+ 1）$f$ 在 $[a,b]$ 上连续 
	+ 2）$f$ 在 ($a,b)$ 内可导
	+ 则：$$\text{可得 }\exists\xi\in(a,b)\text{,使 }f(b)-f(a)=f^{\prime}(\xi)(b-a)$$
+ 图示：
	+ ![[Pasted image 20231225143547.png]]

**柯西中值定理**
+ 定义：
	+ 若满足以下条件： 
	+ 1）$f,F\text{ 在 }[a,b]\text{上连续};$
	+ 2）$f,F\text{ 在 }(a,b)\text{ 内可导,且 }\forall x\in(a,b),F^{\prime}(x)\neq0$
	+ 则：$$\exists\xi\in(a,b)\text{ ,使 }\frac{f(b)-f(a)}{F(b)-F(a)}=\frac{f^{\prime}(\xi)}{F^{\prime}(\xi)}$$
+ 图示：
	+ ![[Pasted image 20240520005038.png]]

**三大定理关系**
![[Pasted image 20240322225640.png]]

## 3.2 导数应用
**凹凸性**
+ 定义：
	+ $\text{设函数}f(x)\text{在区间 }I\text{ 上连续, 如果对}$$I$ 上任意两点 $x_1,x_2$ 
	+ 1）如果恒有 $f(\frac{x_1+x_2}2)<\frac{f(x_1)+f(x_2)}2$，则称 $f(x)$ 在 $I$ 上的图形是凹的
	+ 2）如果恒有 $f(\frac{x_1+x_2}2)>\frac{f(x_1)+f(x_2)}2$，则称 $f(x)$ 在 $I$ 上的图形是凸的
+ 方法：
	+ 用一阶导数的正负 `->` 判断函数的单调性；
	+ 用二阶导数的正负 `->` 判断函数的凹凸性；
+ 判定：
	+ $\text{设函数}f(x)\text{ 在区间 }[a,b]\text{ 上连续},\text{ 在 }(a,b)\text{ 内二阶可导},$
	+ 1）$\text{若在 }(a,b)\text{ 内 }f^{\prime\prime}(x)\text{>0, 则 }f(x)\text{ 在 }[a,b]\text{ 上的图形是凹的}$；
	+ 2）$\text{若在 }(a,b)\text{ 内 }f^{\prime\prime}(x)<0,\text{ 则 }f(x)\text{ 在 }[a,b]\text{ 上的图形是凸的}$

**拐点**
+ 定义：
	+ 连续曲线上，凹凸性质发生变化的分界点；
+ 可能取值点：
	+ 1. ${f^{\prime\prime}(x_0)=0}$；
	+ 2. 二阶导数不存在的点；

**渐近线**
+ 定义：
	+ 1）水平渐近线：若 $\lim_{x\to\infty}f(x)=A\left(\lim_{x\to-\infty}f(x)=A\right.$,或 $\lim_{x\to+\infty}\overline{f(x)=A}$)，那么 $x\to+\infty$ 或 $x\to-\infty$ 时，$y=A\text{ 是曲线 }y=f(x)\text{ 的水平渐近线}.$
	+ 2）垂直渐近线：若 $\lim_{x\to x_0}f(x)=\infty$ ,那么 $x=x_0$ 是 $y=f(x)$ 的垂直渐近线；
	+ 3）斜渐近线：若 $\lim_{x\to\infty}\frac{f(x)}x=a\mathrm{~,~}b=\lim_{x\to\infty}(f(x)-ax)\mathrm{~,~}\text{那么 }\mathrm{~}y=ax+b\mathrm{~}\text{是}$ $y=f(x)\text{ 的斜渐近线}.$
+ 方法： 
	+ 1. 判断水平渐近线 `->` 当 x `->` 无穷时，y 趋向于有限值；
	+ 2. 判断垂直渐近线 `->` 当 x `->` 某一点（有限值），y 趋向于无穷；
	+ 3. 判断斜渐近线 
		+ `->` $\lim_{x\to\infty}\frac{f(x)}x=a$ 有限值；
		+ `->` $\lim_{x\to\infty}(f(x)-ax)=b$ 存在
		+ 此时有斜渐近线；

# Chapter 4：不定积分 
## 4.1 不定积分基础
### 4.1.1 基础概念
**性质 1**：
+  $(\int f(x)\mathrm{d}x)^{\prime}=f(x)$
+ $\mathrm{d}\int f(x)\mathrm{d}x=f(x)\mathrm{d}x$

**性质 2**：
+ $\int f^{\prime}(x)\operatorname{d}x=f(x)+C$
+ $\int\operatorname{d}f(x)=f(x)+C$

**性质 3**：
+ $\int[f(x)\pm g(x)]\operatorname{d}x=\int f(x)\operatorname{d}x\pm\int g(x)\operatorname{d}x$

**性质 4**：
+ $\int kf(x)\operatorname{d}x=k\int f(x)\operatorname{d}x$

### 4.1.2 基础公式
**基础公式**
$$1、\int adx=ax+C\:,\:a是常数$$  
$$2、\int x^{a}dx=\frac{x^{a+1}}{a+1}+C，其中 a 为常数，且 a\neq-1$$ 
$$3、\int\frac{1}{x}dx=\ln|x|+C$$
$$4、\int e^{x}dx=e^{x}+C$$ 
$$5、\int a^{x}dx=\frac{1}{\ln a}a^{x}+C;其中a>0\:,\:目a\neq1$$
$$6、\int\sin xdx=-\cos x+C$$
$$7、\int\cos xdx=\sin x+C$$ 
$$8、\int\sec^{2}xdx=\tan x+C$$ 
$$9、\int\csc^{2}xdx=-\cot x+C$$ 
$$10、\int\tan xdx=-\ln|\cos x|+C$$
$$11、\int\cot xdx=\ln\lvert\sin x\rvert+C$$
$$12、\int\sec xdx=\ln\lvert\sec x+\tan x\rvert+C$$
$$13、\int\csc xdx=-\ln\lvert\csc x+\cot x\rvert+C$$
$$14、\int\frac{dx}{1+x^2}=\arctan x+C$$
$$15、\int\frac1{\sqrt{a^2-x^2}}dx=\arcsin\frac xa+C$$
$$16、\int\frac1{x^2-a^2}dx=\frac1{2a}\ln\left|\frac{x-a}{x+a}\right|+C$$
$$17、\int\frac{dx}{\sqrt{1-x^2}}=\arcsin x+C$$
$$18、 \int\frac 1{a^2+x^2}dx=\frac 1 a\arctan\frac xa+C$$ 
$$19、\int\frac{dx}{\sqrt{x^2+a^2}}=\ln (x+\sqrt{x^2+a^2})+C$$
$$20、\int\frac{dx}{\sqrt{x^2-a^2}}=\ln\left|x+\sqrt{x^2-a^2}\right.|+C$$

**三角函数合集**
**常见三角函数积分**
+ 和求导一一对应：
+ $$\int\sin xdx=-\cos x+C、\int\cos xdx=\sin x+C$$
+ $$\int\tan xdx=-\ln|\cos x|+C、\int\cot xdx=\ln\lvert\sin x\rvert+C$$
+ $$\int\sec xdx=\ln\lvert\sec x+\tan x\rvert+C、\int\csc xdx=-\ln\lvert\csc x+\cot x\rvert+C$$
+ $$\int\sec^{2}xdx=\tan x+C、\int\csc^{2}xdx=-\cot x+C$$
+  $$\int\tan x secx=\sec x+C、\int{\cot x\,\csc x}\,dx=-csc x+C$$

**常见反三角函数积分**
+ $$\int\frac{dx}{\sqrt{1-x^2}}=\arcsin x+C$$
+ $$\int\frac1{\sqrt{a^2-x^2}}dx=\arcsin\frac xa+C$$
+ $$\int\frac{dx}{1+x^2}=\arctan x+C$$
+ $$\int\frac 1{a^2+x^2}dx=\frac 1 a\arctan\frac xa+C$$


## 4.2 不定积分求解
### 4.2.1 方法一：第一类换元积分法
**第一类换元积分法**
+ 定义：
	+ 又称作凑微分法；
	+ 若 $\int f(u)\mathrm{d}u=F(u)+C$，$\text{则}\int f[\varphi(x)]\varphi^{\prime}(x)\operatorname{d}x=\int f[\varphi(x)]\operatorname{d}\varphi(x)=F[\varphi(x)]+C$

**凑微分形式总结**：常见函数
+ 1. $$\int f( ax+ b) dx= \frac 1a\int f( ax+ b)d( ax+ b)$$
+ 2. $$\int x^mf( ax^{m+ 1}+ b)dx=\frac 1{( m+ 1) a}\int f( ax^{m+ 1}+ b)d(ax^{m+1}+ b)\quad\quad\quad ( m\neq- 1) $$
+ 3. $$\int f( \sqrt {x}) \frac {\mathrm{d} x}{\sqrt {x}}= 2\int f( \sqrt {x})d( \sqrt x)$$
+ 4. $$\int f( e^x) \mathrm{e} ^xdx= \int f( \mathrm{e} ^x)d(\mathrm{e} ^x)$$
+ 5. $$\int f(\ln x)\:\frac{1}{x}\mathrm{d}x=\int f(\ln x)\mathrm{d}(\ln x)$$

**凑微分形式总结**：常见三角函数
+ 1. $$\int f(\sin x)\cos\:x\mathrm{d}x=\int f(\sin x)\mathrm{d}(\sin x)$$
+ 2. $${\int}f(\cos x)\sin x\mathrm{d}x=-{\int}f(\cos x)\mathrm{d}(\cos x)$$
+ 3. $$\int f(\tan x)\:\frac{1}{\cos^{2}x}\mathrm{d}x=\int f(\tan x)\mathrm{d}(\tan x)$$
+ 4. $${\int}f(\arcsin x)\:\frac{1}{\sqrt{1-x^2}}\mathrm{d}x=\int f(\arcsin x)\mathrm{d}(\arcsin x)$$
+ 5. $${\int}f(\arctan x)\:\frac1{1+x^2}\mathrm{d}x=\int f(\arctan x)\mathrm{d}(\arctan x)$$


### 4.2.2 方法二：第二类换元积分法
**第二类换元积分法**
+ 定义：
	+ $$\int f(x)\mathrm{d}x=\int f[\varphi(t)]\varphi^{\prime}(t)\mathrm{d}t=F(t)+C=F[\varphi^{-1}(x)]+C$$
+ 方法： 
	+ 关键是变量代换的选取 `->` 把 x 带换掉了，带换成其他函数 `->` 做出结果后，还要用反函数带回去；

**形式总结**
 + 以下三种形式：$$\begin{aligned}&\sqrt{a^2-x^2} \\&\sqrt{a^2+x^2} \\&\sqrt{x^2-a^2}\end{aligned}$$
+ 分别可以使用以下三种形式的 x 来带入，进而消掉根号：$$\begin{aligned}x&=a\sin t(a\cos t)\\\\x&=a\tan t\\\\x&=a\sec t\end{aligned}$$

+ 目的：把**根号可以去掉**；

### 4.2.3 方法三：分部积分法 
**分部积分法**
+ 定义：
	+ 设 $u(x),\nu(x)$ 有连续一阶导数，则 $\int udv=uv-\int vdu$
+ 方法：    
	+ 适用于**两类不同函数相乘**；

**使用场合**
+ 多项函数 × 指数|三角：
	+ 1. $\int p_n(x)e^{ax}\operatorname{d}x$
		+ 凑指数
	+ 2. $\int p_n(x)\sin ax\operatorname{d}x$
		+ 凑三角
	+ 3. $\int p_n(x)\cos axdx$
		+ 凑三角
+ 多项函数 × 对数|反三角：
	+ 4. $\int P_n(x)\ln xdx$
		+ 凑多项式
	+ 5. $\int P_n(x)\arctan xdx$
		+ 凑多项式
	+ 6. $\int P_n(x)\arcsin xdx$
		+ 凑多项式
+ 指数 × 三角
	+ 7. $\int e^{\alpha x}\sin\beta xdx$
		+ 凑谁都行
	+ 8. $\int e^{\alpha x}\cos\beta xdx$
		+ 凑谁都行

# Chapter 5：定积分及反常积分 
## 5.1 定积分概念
**定积分定义**
+ 定义：
	+ $f(x)$ 在 $[a,b]$ 上有界，在 $[a,b]$ 上任意插入分点，分成 n 个小区间 $\Delta x_{1}\Delta x_{2}\cdots\Delta x_{n}$ ，任取一点 i，有：$$\int_{a}^{b}f(x)dx=\lim_{λ\to0}\sum_{x=1}^{n}f(\xi_{i})\Delta x_{i}$$
	+ 其中：$$\lambda=\max\{\Delta x_{1}\cdots\Delta x_{n}\}$$
+ 定积分存在性：
	+ 条件 1：$f(x)$ 在 $[a,b]$ 上连续 `->` 可积；
	+ 条件 2：$f(x)$ 在 $[a,b]$ 上有界，且有有限个间断点 `->` 可积；
	+ 条件 3：$f(x)$ 在 $[a,b]$ 上仅有有限个第一类间断点；
+ 总结：
	+ 有界是定积分存在的必要条件；
	+ 可积是定积分存在的充分条件；

**定积分性质**
+ 1. $$\int_{a}^{b}(\alpha f(x)+\beta g(x))dx=\alpha\int_{a}^{b}f(x)dx+\beta\int_{a}^{b}g(x)dx$$
+ 2. $$\int_{a}^{b}f\left(x\right)dx=-\int_{b}^{a}f\left(x\right)dx$$
+ 3. 当 $a<c<b$ 时： $$\int_{a}^{b}f\left(x\right)dx=\int_{a}^{c}f\left(x\right)dx+\int_{c}^{b}f\left(x\right)dx$$

## 5.2 变上限定积分
**微积分基本定理**
+ 定义：
	+ $\text{若 }f(x)\text{在 }[a,b]\text{ 上连续，则：}\int_a^xf(t)\mathrm{d}t\text{ 在 }[a,b]$ 上可导，且有 $$(\int_a^xf(t)\mathrm{d}t)^{\prime}=f(x)$$
+ 其他结论：
	+ $$(\int_{\varphi(x)}^{\psi(x)}f(t)dt)^{\prime}=f(\psi(x))\psi^{\prime}(x)-f(\varphi(x))\varphi^{\prime}(x)$$

**积分上限函数的奇偶性**
+ 1. 若 f (x)是奇函数，则 $\int_0^xf(t)dt$ 是偶函数；
+ 2. 若 f (x)是偶函数，则 $\int_0^xf(t)dt$ 是奇函数；

**变上限定积分三大方法**
+ 方法一：公式计算
	+ 举例： $$(\int_{e^{x}}^{x^{2}}f(t)dt)^{\prime}=f(x^{2})\cdot2x-f(e^{x})e^{x}$$
+ 方法二：提取 x 
	+ 举例： $$\int_{0}^{x}(x-t)f(t)dt;=x\int_{0}^{x}f(t)dt-\int_{0}^{x}tf(t)dt$$
	+ 积分域以及被积式子里面都有 x；
	+ 能提出 x 时：拆项，把 x 提取出来；
+ 方法三：换元法
	+ 举例： $$\int_{0}^{x}cos(x-t)^{2}dt\frac{x-t=u}{}\int_{0}^{x}cos u^{2}du$$
	+ 积分域以及被积式子里面都有 x；
	+ 不能提出 x 时：换元；
		+ 注意：换元时，x 是常数，t 和 u 是被积分变量；
	+ 举例：当出现上下限都没有 x，但被积分式中有 x 时，需要把 x 换元、带入到上下限当中；
		+ 令 $x+t=u$ 后： $$\int_{1}^{2}f(x+t)dt=\int_{x+1}^{x+2}f(u)du$$

## 5.3 定积分的计算
### 5.3.1 方法一：牛顿-莱布尼茨公式
**计算基础**：牛顿 - 莱布尼茨公式 
+ 定义：
	+ $\text{设 }F(x)\text{ 为连续函数 }f(x)$ $\text{在 }[a,b]\text{ 上的一个原函数,则}$：$\int_{a}^{b}f(x)dx=F(b)-F(a)$，也称之为微积分基本公式；

### 5.3.1 方法二：定积分的换元法
**公式**
+ $$\int_{a}^{b}f(x)\operatorname{d}x=\int_{\alpha}^{\beta}f(\varphi(t))\varphi^{\prime}(t)\operatorname{d}t$$

### 5.3.2 方法三：定积分的分部积分法
**公式**
+ $$\int_{a}^{b}u\operatorname{d}v=uv\bigg|_{a}^{b}-\int_{a}^{b}v\operatorname{d}u$$

### 5.3.3 方法四：定积分性质
**方法一：** 利用奇偶性，周期性 
+ $$\int_{-a}^af(x)\operatorname{d}x=\begin{cases}0,&f(x)&\text{为奇函数,}\\2\int_0^af(x)\operatorname{d}x,&f(x)&\text{为偶函数}.\end{cases}$$
+ $$\int_a^{a+T}f(x)\operatorname{d}x=\int_0^Tf(x)\operatorname{d}x.$$

**方法二：** 利用已有公式
+  $$\begin{aligned}(1)&\int_0^{\frac\pi2}\sin^nx\operatorname{d}x=\int_0^{\frac\pi2}\cos^nx\operatorname{d}x=\begin{cases}\frac{n-1}n\frac{n-3}{n-2}\cdots\frac12\frac\pi2,&n\text{偶}\\\frac{n-1}n\frac{n-3}{n-2}\cdots\frac23,&n\text{奇}&\end{cases}\\(2)&\int_0^{\pi}x\cdot f(\sin x)\operatorname{d}x=\frac\pi2\int_0^{\pi}f(\sin x)\operatorname{d}x\end{aligned}$$

**方法三**：常见结论
+ 1. $$\int_{0}^{a}\sqrt{a^{2}-x^{2}}dx=\frac{\pi a^{2}}{4}(a>0)$$
+ 2. $$\int_{0}^{a}\sqrt{2ax-x^{2}}dx=\frac{\pi}{4}a^{2}$$
+ 3. $$\int_{0}^{2a}\sqrt{2ax-x^{2}}dx=\frac{\pi}{2}a^{2}$$


## 5.4 反常积分
**两类反常积分**
+ 无穷区间上的反常积分：
	+ $$\int_{a}^{+\infty}f(x)dx=\lim_{t\to+\infty}\int_{a}^{t}f(x)dx$$
	+ $$\int_{-\infty}^{b}f(x)dx=\lim_{t\to-\infty}\int_{t}^{b}f(x)dx$$
+ 无穷函数的反常积分： 
	+ $$\int_a^bf(x)dx=\lim_{t\to a^+}\int_t^bf(x)dx$$
	+ $$\int_{a}^{b}f(x)dx=\lim_{t\to b^{-}}\int_{a}^{t}f(x)dx.$$
	+ $$\int_{a}^{b}f(x)dx=\int_{a}^{c}f(x)dx+\int_{c}^{b}f(x)dx$$

**题型一**：判断反常积分敛散性
+ 1. 定义法；
	+ 根据当前被积分式，求出其原函数，求原函数在被积分区间上的极限，看起极限值是否收敛；
+ 2. 比较判别法；
	+ 比较法；  
	+ 比较法的极限形式；
+ 3. P 积分；
	+ 无穷限反常积分
		+ $$\int_{a}^{+\infty}\frac{1}{x^{P}}dx\begin{cases}P>1&\text{收敛}\\P\leq1&\text{发散}\end{cases}(a>0)$$
		+ `->` $P>1$ 时收敛，$P<1$ 时发散
	+ 无界函数的反常积分
		+ $$\int_a^b\frac1{\left(x-a\right)^P}dx,\int_a^b\frac1{\left(b-x\right)^P}dx\quad\begin{cases}{P}<1&\text{收敛}\\P\geq1&\text{发散}\end{cases}$$
		+ `->` $P<1$ 时收敛，$P>1$ 时发散
+ 哪个方便用哪个；

**题型二**：反常积分的计算
+ 算个定积分 + 算个极限；
+ 方法一：换元法 
+ 方法二：分部法

## 5.5 定积分应用
**平面图形的面积**
+ 情况一：平面坐标
	+ 若平面域 $D$ 由曲线 $y=f(x),y=g(x)(f(x)\geq g(x))$, $x=a,\quad x=b\quad(a<b)$ 所围成，则：
	+ $$S=\int_{a}^{b}[f(x)-g(x)]dx$$
+ 情况二：极坐标
	+ 若平面域 $D$ 由曲线 $\rho=\rho(\theta),\theta=\alpha,\theta=\beta(\alpha<\beta)$ 所围成，则： 
	+ $$S=\frac 12\int_\alpha^\beta\rho^2 (\theta)\mathrm{d}\theta$$

**旋转体的体积**
+ 1. 绕 X 轴旋转时： $$V_{x}=\pi\int_{a}^{b}f^{2}(x)\operatorname{d}x$$
+ 2. 绕 Y 轴旋转时： $$V_y=2\pi\int_a^bxf(x)\operatorname{d}x$$
+ 3.![[Pasted image 20241028004801.png]]

**弧长的计算**
+ $$\begin{aligned}
&1)C:y=y(x),\quad a\leq x\leq b,\quad s=\int_a^b\sqrt{1+{y^{\prime}}^2}dx \\
&2)C:\begin{cases}x=x(t)\\y=y(t)\end{cases}\alpha\leq t\leq\beta.\quad s=\int_\alpha^\beta\sqrt{x^{\prime2}+y^{\prime2}}dt \\
&3)C:\rho=\rho(\theta),\alpha\leq\theta\leq\beta.\quad s=\int_{\alpha}^{\beta}\sqrt{\rho^{2}+{\rho^{\prime}}^{2}}d\theta 
\end{aligned}$$
![[Pasted image 20241028004817.png]]
# Chapter 6：微分方程
## 6.1 一阶微分方程
**题型一**：可分离变量
+ 形式：
	+ $$y^{\prime}=f(x)g(y)$$
+ 方法： 
	+ $\frac{dy}{dx}=f(x)g(y)$ `->` $\frac{dy}{g(y)}=f(x)dx$ 可以把 $g(y)$ 和 $dy$ 、$f(x)$ 个 $dx$ 分离到等式的两边 `->` 可分离变量的微分方程；
	+ 可分离变量的解：两边积分 $$\int\frac{dy}{g(y)}=\int f(x)dx$$

**题型二**：一阶齐次方程
+ 形式：
	+ $$\frac{dy}{dx}=\varphi(\frac{y}{x})$$
+ 方法： 
	+ 第零步：整理成齐次方程的形式，左边只有 $\frac{dy}{dx}$，即 $\frac{dy}{dx}=\varphi(\frac{y}{x})$；
	+ 第一步：写下 $u=\frac{y}{x}$
	+ 第二步：因为 $y=xu$，所以对 y 求导后，可以得到 $\frac{dy}{dx}=u+x\frac{du}{dx}$ ，即得到了 $y^{\prime}=\frac{dy}{dx}=u+x\frac{du}{dx}=u+xu^{\prime}$ 的表达式；
	+ 第三步：带会原函数，得到 $u+x\frac{du}{dx}=\varphi(\frac{y}{x})$，这个方程是可分离变量；
		+ 即：把其变成可分离变量，求解；

**题型三**：一阶线性方程
+ 形式： 
	+ $$y^{\prime}+P(x)y=Q(x)$$
+ 方法： 
	+ 整理成标准形式，带通解公式
	+ $$y=e^{-\int p(x)dx}\left[\int Q(x)e^{\int p(x)dx}dx+C\right]$$

## 6.2 二阶微分方程
**题型四**：二阶常系数齐次方程
+ 形式： 
	+ $$y^{\prime\prime}+py^{\prime}+qy=0$$
+ 方法： 
	+ 第一步：写特征方程
	+ 第二步：找出特征根
	+ 第三步，根据根的方程，写出对应式子
		+ 若是不等实根 
			+ 通解： $y=C_1e^{r_1x}+C_2e^{r_2x}$
		+ 若是相等实根 
			+ 通解：$y=e^{rx}(C_1+C_2x)$
		+ 若是共轭复根 
			+ 通解：$y=e^{\alpha x}(C_1\cos\beta x+C_2\sin\beta x)$

**题型五**：二阶常系数非齐次方程
+ 形式： 
	+ 方程： $$y^{\prime\prime}+py^{\prime}+qy=f(x)$$
	+ 两种非齐次项：
		+ 1. $$f(x)=e^{\lambda x}P_m(x)$$
		+ 2. $$f (x)=e^{\alpha x}\left\lfloor P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x\right\rfloor$$
**总结**：方法
+ 1. 确定解由几个成分构成，如果由多个成分构成，需要分别为其设特解；
+ 2. 求出齐次通解
	+ 第一步：写特征方程
	+ 第二步：找出特征根
	+ 第三步，根据根的方程，写出对应式子
		+ 注意：
			+ 齐次通解中的 $e$ 是 $e^{r x}$，而不是 $e^{\lambda x}$ 
			+ 所以可以由齐次方程的通解式，知道当前非齐次方程的特征方程 $r$，但注意是 $r$、不是齐次式中的 $\lambda$
		+ 若是单实根
			+ 通解：$y=C_1e^{r_1x}$
		+ 若是不等实根 
			+ 通解： $y=C_1e^{r_1x}+C_2e^{r_2x}$
		+ 若是相等实根 
			+ 通解：$y=e^{rx}(C_1+C_2x)$
		+ 若是共轭复根：$r_{1,2}=\alpha\pm i\beta$
			+ $\beta$ 为求出来的特征根后背的系数，即此式子 $r_{1,2}=\alpha\pm i\beta$ 中的 $\beta$
			+ 通解：$y=e^{\alpha x}(C_1\cos\beta x+C_2\sin\beta x)$
+ 3. 设特解 $y^{*}$： 
	+ 为每个部分设出待定特解为：$y^{*}=x^{k}Q_{m}(x)e^{\lambda x}$ 或者 $y^{*}=x^{k}e^{\alpha x}\bigl[R_{m}^{(1)}(x)\cos\beta x+R_{m}^{(2)}(x)\sin\beta x\bigr]$
+ 4. 求待定特解各项： 
	+ $e^{\lambda x}$ 或 $e^{\alpha x}$
		+ `->` 直接从原式中带进来 `->` 顺便还定了这个 $\lambda$ 或者 $\alpha$ 的值；
	+ $Q_m(x)$ 
		+ 根据 $P(x)$ 的情况，分析：
		+ 如果 $P(x)$ 是情况一：$P_{m}(x)$
			+ 观察原式的 $P_{m}(x)$
			+ 如果是常数项，设为 $a$；
			+ 如果是一次项，设为 $ax+b$；
			+ 如果是二次式，设为 $ax^2+bx+c$；
		+ 如果 $P(x)$ 是情况二：$\bigl[R_{m}^{(1)}(x)\cos\beta x+R_{m}^{(2)}(x)\sin\beta x\bigr]$
			+ 如果 cos 和 sin 都存在：
				+ 取原式中 $P_{l}^{(1)}(x)$ 和 $P_{n}^{(2)}(x)$ 当中的最高项；
					+ 原式为 $f (x)=e^{\alpha x}\left\lfloor P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x\right\rfloor$
				+ 如果是常数项，设为 $A\sin x+B\cos x$；
				+ 如果是一次项，设为 $(Ax+B)\sin x+(Cx+D)\cos x$  类似这种形式；
			+ 如果 cos 和 sin 只有一个存在：
				+ 其存在的那个函数当中的值作为最高项，步骤同 cos 和 sin 都存在时；
	+ $x^{k}$ 
		+ 确定 $x^{k}$ 的 $k$：
		+ 如果是情况一：
			+ 如何确定几重根 `->` k 的数值，是当前方程的**齐次方程中求出来的特征方程中、含根 $\lambda$ 的次数**。
			+ 举例：求齐次方程的通解后，得到 $r_1=3,r_2=1$ ，若 $\lambda =2$，则特征方程中出现了 0 次根 $\lambda$  `->` 所以 $k=0$
		+ 如果是情况二：
			+ 根据 $\alpha+i\beta$ 是方程的几重根，判断 $k$ 的取值
				+ $\alpha$ 来自 $e^{\alpha x}$ 中，$\beta$ 来自 $P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x$ 的三角函数中；
			+ 如果是单根，这个 $x^{k}$ 里面的 $k$ 就是 $1$ 次方，如果是双根，这个里面的 $k$ 就是 $2$ 次方；
			+ 注意： 
				+ 如果 $r_{1,2}=\pm 1$，此时表示是一个特征根，因为两个特征根一样；
				+ 所以如果解出 $\alpha+i\beta=\pm 1$ ，则此时表示的是一重根，而不是两重根；
+ 5. 确定系数与任意常数
	+ （1）确定非齐次项待定特解的系数
		+ 在前面设好了 $y^{*}$ 的各个成分后，因为此时 $y^{*}$ 当中还有待定系数，此时将设好的函数代换原方程，比较两端同次幂的系数，然后得到 $y^{*}$ 的结果；
		+ 假如当前方程式是 $y^{\prime\prime}+y=\sin x$，此时就需要将 $y({*})$ 和 $y^{\prime\prime}(*)$ 代入原方程中，然后比较两端同次幂的系数，然后得到 $y^{*}$ 中各个系数的结果；
	+ （2）确定齐次项通解的任意常数 $C_1$ 和 $C_2$
		+ 在原方程式中，找出两个方程的特解，比如求出 $f(0)=0$、$f^{\prime}{0}=1$；
		+ 将其代入齐次方程的通解式中、解出任意常数；
		+ 注意：非齐次的特解在定出系数后，也需要带入到齐次方程的通解式当中，帮助定出任意常数；
+ 6. 若是三阶及其以上的微分方程，按照以下方法合并
	+ ![[Pasted image 20240815124753.png]]
+ 7. 如果需要求出整个方程的特解，则可以将限制条件代入到通解式当中，定出其中的常数 $C_1$，$C_2$，得到微分方程的特解；
+ 补充：
	+ 1. 非齐次项部分两个解的差，等于齐次的一个解；
	+ 2. 非齐次项的解具有叠加性；

**题型六**：$y^{\prime\prime}=f(x,y^{\prime})$ 型可降阶方程
+ 形式： 
	+ $$y^{\prime\prime}=f(x,y^{\prime})$$
+ 方法： 
	+ 令： ${y^{\prime}=P,y^{\prime\prime}=\frac{dP}{dx}}$
	+ 得到： $\frac{dp}{dx}=f(x,p)$ 关于 p、x 的一阶方程，然后进行分离变量；

**题型七**：$y"=f(y,y^{\prime})$ 型可降阶方程 
+ 形式： 
	+ $$y"=f(y,y^{\prime})$$
+ 方法：
	+ 设： $y^{\prime}=P$、$y^{\prime\prime}=\frac{dp}{dy}P$；
	+ 变成只有 y、p，没有 x 的一阶方程，然后使用分离变量法；

# Chapter 7：多元函数微分学
## 7.1 多元函数基础 
**定义**：多元函数的极限
+ $$\lim_{(x,y)\to(x_0,y_0)}f(x,y)=A$$

**定义**：多元函数的连续性
+ $$\lim_{(x,y)\to(x_0,y_0)}f(x,y)=f(x_0,y_0)$$

**定义**：偏导数
+ 对 X：
	+ $$\lim_{\Delta x\to0}\frac{f\left(x_{0}+\Delta x,y_{0}\right)-f\left(x_{0},y_{0}\right)}{\Delta x}$$
	+ 其他形式：$$\frac{\partial f(x,y)}{\partial x}$$
+ 对 Y：
	+ $$lim_{\Delta y\to0}\frac{f(x_{0},y_{0}+\Delta y)-f(x_{0},y_{0})}{\Delta y}$$
	+ 其他形式： 
		+ $$\frac{\partial f(x,y)}{\partial y}$$

**定义**：偏导数的几何意义
+ 曲面 $Z=f(x,y)$
+ 1.  $f_x(x_0,y_0)$ 代表的是在 $y=f(x)$ 这一直线上，$x_0$ 点对 $y=f(x)$ 的切线；
+ 2.  $f_y(x_0,y_0)$ 代表的是在 $x=f(y)$ 这一直线上，$x_0$ 点对 $x=f(y)$ 的切线； 

**定义**：高阶偏导数
+ $$\frac{\partial}{\partial x}\biggl(\frac{\partial z}{\partial x}\biggr)=\frac{\partial^{2}z}{\partial x^{2}}=f_{xx}^{\prime\prime}\quad\frac{\partial}{\partial y}\biggl(\frac{\partial z}{\partial x}\biggr)=\frac{\partial^{2}z}{\partial x\partial y}=f_{xy}^{\prime\prime}$$
+ $$\frac{\partial}{\partial x}\Bigg(\frac{\partial z}{\partial y}\Bigg)=\frac{\partial^{2}z}{\partial y\partial x}=f_{yx}^{\prime\prime}\quad\frac{\partial}{\partial y}\Bigg(\frac{\partial z}{\partial y}\Bigg)=\frac{\partial^{2}z}{\partial y^{2}}=f_{yy}^{\prime\prime}$$

+ 并且：$$\frac{\partial^2z}{\partial x\partial y}=\frac{\partial^2z}{\partial y\partial x}$$

**定义**：多元函数的全微分
+ 若 $\Delta z=f(x_0+\Delta x,y_0+\Delta y)-f(x_0,y_0)=A\Delta x+B\Delta y+o(\rho)$，则称函数 $z=f(x,y)$ 在点 $(x_0,y_0)$ 处可微分；
+ 即：$$dz=A\Delta x+B\Delta y$$

**定理**：可微的必要条件
+ $\begin{aligned}&\text{如果}z=f(x,y)\text{ 在点}\left(x_0,y_0\right)\text{处可微},\text{则在点}\left(x_0,y_0\right)\text{处}\frac{\partial z}{\partial x},\frac{\partial z}{\partial y}\text{ 必定存在,即以下式子存在}\end{aligned}$：$$\mathbf{d}z=\frac{\partial z}{\partial x}\mathbf{d}x+\frac{\partial z}{\partial y}\mathbf{d}y$$
+ 可微分 `->` 可导；
+ 可导 `-x>` 可微分；
+ 一阶偏导数连续 `->` 可微分；
+ 可微分 `-x>` 一阶偏导数连续；

**定理**：可微的充分条件
+ 如果 $z=f(x,y)$ 的偏导数 $\frac{\partial z}{\partial x},\frac{\partial z}{\partial y}$ 在点 $(x_0,y_0)$ 处连续，则函数 $z=f(x,y)$ 在点 $(x_0,y_0)$ 处可微； 

**解题**：可微、可导、连续、偏导连续的判断
+ 判断是否可微：
	+ 1. 定义法：
		+ 第一步：判断 $f_{x}(x_{0},y_{0})与 f_{y}(x_{0},y_{0})\text{ 是否都存在}$；
		+ 第二步：使用以下定义，判断其重极限是否存在；
			+ 公式： $$\lim_{(\Delta x,\Delta y)\to(0,0)}\frac{\Delta z-[f_{x}(x_{0},y_{0})\Delta x+f_{y}(x_{0,}y_{0})\Delta y]}{\sqrt{\left(\Delta x\right)^{2}+\left(\Delta y\right)^{2}}}$$
+ 判断是否可导：
	+ 1. 定义法：分别求对 x 的偏导、y 的偏导，使用偏导数定义、分析偏导数对应的一元函数导数是否存在；
		+ 公式（X 偏导）：$$\lim_{\Delta x\to0}\frac{f\left(x_{0}+\Delta x,y_{0}\right)-f\left(x_{0},y_{0}\right)}{\Delta x}$$
	+ 2. 先带后求：
+ 判断是否连续：
	+ 1. 定义法：
		+ （1）证明连续：在某点的函数值是否等于其函数的极限值，如果等于、则连续；
		+ （2）证明不连续：同；
	+ 2. 特殊 `y` 值法：
		+ 用某一固定的 y 的函数带入函数当中，经常用于证明不连续；
		+ 常用形式：
			+ $y=kx$ 
			+ $y=0$
+ 判断偏导数是否连续：
	+ 注意：
		+ 多元函数连续 `≠` 多元函数偏导数连续；
		+ 偏导数是否连续，是指的 **对 X 或对 Y 的偏导数** 这个导函数是否连续；
	+ 1. 定义法：利用对 X 或对 Y 的偏导数函数定义求解：
		+ 如果以下公式不成立，则偏导数不连续；
		+ 公式（对 X 的偏导数函数）：$$\lim_{x\to0,y\to0}f_{x}(x,y)=f_{x}(0,0)$$

## 7.2 多元函数微分法
多元函数微分法中的问题：
+ （1）复合函数微分法；
+ （2）隐函数微分法；

**定理**：多元复合函数求导法则
+ 设 $u=u(x,y),\quad v=v(x,y)$ 在点 $(x,y)$ 处有对 x 及对 $y$ 的偏导数，函数 $z=f(u,\nu)$ 在对应点 $(u,\nu)$ 处有连续偏导数，则 $z=f[u(x,y),v(x,y)]$ 在点 $(x, y)$ 处的两个偏导数存在，且有：
+ $$\frac{\partial z}{\partial x}=\frac{\partial z}{\partial u}\frac{\partial u}{\partial x}+\frac{\partial z}{\partial\nu}\frac{\partial v}{\partial x},\quad\frac{\partial z}{\partial y}=\frac{\partial z}{\partial u}\frac{\partial u}{\partial y}+\frac{\partial z}{\partial\nu}\frac{\partial\nu}{\partial y}$$

**定理**：全微分形式不变性
+ 设函数 $z=f(u,v),\quad u=u(x,v)$ 及 $\nu=\nu(x,y)$ 都有连续的一阶偏导数，则复合函数 $z=f[u(x,y),v(x,y)]$ 的全微分不变性：
	+ $$\mathbf{d}z=\frac{\partial z}{\partial x}\mathbf{d}x+\frac{\partial z}{\partial y}\mathbf{d}y=\frac{\partial z}{\partial u}\operatorname{d}u+\frac{\partial z}{\partial\nu}\operatorname{d}\nu.$$
+ 多元函数也具有微分形式的不变性； 
	+ 由此推导而来：$$\frac{\partial z}{\partial x}=\frac{\partial z}{\partial u}\frac{\partial u}{\partial x}+\frac{\partial z}{\partial\nu}\frac{\partial\nu}{\partial x},\quad\frac{\partial z}{\partial y}=\frac{\partial z}{\partial u}\frac{\partial u}{\partial y}+\frac{\partial z}{\partial v}\frac{\partial\nu}{\partial y}$$

**定义**：多元函数隐函数
+ 由方程 $F(x, y)=0$ 确定的隐函数 $y=(x)$，得：
+ $$y^{\prime}=-\frac{F_{x}^{\prime}}{F_{y}^{\prime}}$$

**定理**：隐函数存在定理
+ 1. $F(x,y)$ 在点 $M_0(x_0,y_0)$ 邻域内连续可偏导； 
+ 2. $F(x_0,y_0)=0$；
+ 3. $F_y\:\prime(x_0,y_0)\neq0$ 
+ 则由函数 $F(x,y)$ 在 $M_{0}$ 邻域内唯一确定一个连续可导函数 $y=f(x)$ 使 $y_0=f(x_0)$
+ 则： $$\frac{dy}{dx}=-\frac{F_{x}'}{F_{y}'}$$

**定理**：多元隐函数存在定理
+  $F(x,y,z)$ 在点 $M_{0}(x_{0},y_{0},z_{0})$ 邻域内连续可偏导，且 $F(x_{0},y_{0},z_{0})=0,F_{z}\:{\prime}(x_{0},y_{0},z_{0})\neq0$ 则由 $F(x,y,z)=0$ 在 $M_{0}$ 邻域内唯一确定一个连续可导函数 $z=\varphi(x,y)$ 且 $z_0=\varphi(x_0,y_0)$
+ 则：$$\frac{\partial z}{\partial x}=-\frac{F_{x}’}{F_{z}’},\frac{\partial z}{\partial y}=-\frac{F_{y}’}{F_{z}’}$$
## 7.3 多元函数的极值与最值
**定义**：多元函数的极值
+ 在一个邻域中，多元函数的最大值或者最小值； 
+ 若在点 $(x_0,y_0)$ 的某邻域中恒成立不等式：$$f(x,y)\leq f(x_0,y_0)\quad(f(x,y)\geq f(x_0,y_0))$$
+ 则称 f 在点 $(x_0,y_0)$ 取得极大值 (极小值)，点 $(x_0,y_0)$ 称为 `f` 的极大值点 (极小值点)；
+ 极大值与极小值统称为极值，极大值点与极小值点统称为极值点；

**定义**：多元函数的驻点
+ 多元函数的偏导数等于 0 的点，称之为多元函数的驻点；

**定理**：多元函数极值存在的必要条件
+ 如果 $z=f(x,y)$ 在点 $(x_0,y_0)$ 有偏导数，并且在 $(x_0,y_0)$ 处取得极值，则有：$$f_{x}^{\prime}(x_{0},y_{0})=0，f_{y}^{\prime}(x_{0},y_{0})=0$$

**定理**：极值的充分条件 
**多元函数的驻点极值性判断**
+ 当 $z=f(x,y)$ 在点 $P_0(x_0,y_0)$ 的某邻域内有二阶连续偏导数，又 $f_x^{\prime}(x_0,y_{0})=f_y^{\prime}(x_0,y_{0})=0$ 时，$A=f_{xx}^{\prime\prime}(x_{0},y_{0})\quad\quad B=f_{xy}^{\prime\prime}(x_{0},y_{0})\quad\quad C=f_{yy}^{\prime\prime}(x_{0},y_{0})$；
+ 1. 如果是 $AC-B^{2}>0$，则有极值
	+ 1. A<0，是极大值；
	+ 1. A>0，是极小值；
+ 1. 如果是 $AC-B^{2}<0$，则无极值
+ 2. 如果是 $AC-B^{2}=0$，则只能用定义判断

**定义**：条件极值
+ 已知 $z=f(x,y)$，其极值在 $\varphi(x,y)=0$ 的条件之下，求其极值为条件极值；

**定理**：拉格朗日乘数法
+ （1）单个约束条件时：令 $F(x,y,\lambda)=f(x,y)+\lambda\varphi(x,y)$
	+ 则取到极值的必要条件为：$$\begin{cases}F_x=f_x^{\prime}(x,y)+\lambda\varphi_x^{\prime}(x,y)=0,\\F_y=f_y^{\prime}(x,y)+\lambda\varphi_y^{\prime}(x,y)=0,\\F_\lambda=\varphi(x,y)=0,\end{cases}$$
+ （2）多个约束条件时：$f(x,y,z)\text{ 在条件 }\varphi(x,y,z)=0,\psi(x,y,z)=0$ 条件下的条件极值 
	+ 令 $F(x,y,z,\lambda,\mu)=f(x,y,z)+\lambda\varphi(x,y,z)+\mu\psi(x,y,z)$

# Chapter 8：重积分
## 8.1 二重积分
**定义**：二重积分
+ 如果 $f(x,y)$ 是区域 D 上的有界函数，将区域 D 任意的分成 n 个区域：$\sigma_{1}$ 、$\sigma_{2}$.... $\sigma_{n}$，每个 $\sigma_{n}$ 上任取一点 $(\xi_{i},\eta_{i})$，做 $f(\xi,\eta_{i})\Delta\sigma_{i}$ ，当 $\lambda\to0$ 时：
+ 称下式为二重积分： $$\lim_{\lambda\to0}\sum_{i=1}^{n}\Delta\sigma_{i}f\left(\xi_{i},\eta_{i}\right)=\int\int_{D}f(x,y)d\sigma $$

**定理**：二重积分的性质
+ （1）
	+ 如果在 D 上，$f(x,y)\leq g(x,y)$ ，则有不等式：
	+ $$\int\int_Df(x,y)d\sigma\leq\int\int_Dg(x,y)d\sigma $$
+ （2）
	+ 若在 $D$ 上有 $m\leq f(x,y)\leq M$，则： 
	+ $$mS\leq\iint_Df(x,y)\mathrm{d}\sigma\leq MS$$
+ （3）
	+ 积分的绝对值，小于绝对值的而积分
	+ $$\left|\iint_Df(x,y)\mathrm{d}\sigma\right|\leq\iint_D\left|f(x,y)\right|\mathrm{d}\sigma.$$
+ （4）
	+ 如果 $f(x,y)$ 在区域 `D` 上的数值恒等于 `1`，则其二重积分就是： 
	+ $$\int\int_{D}\left(1)  d\sigma=\sigma\times1\right.$$

**定理**：二重积分的中值定理
+ 设函数 $f(x,y)$ 在闭区域 `D` 上连续，`S` 为区域 `D` 的面积，则在 `D` 上至少存在一点 $(\xi,\eta)$，使得：$$\iint_Df(x,y)\mathrm{d}\sigma=f(\xi,\eta)\cdot S$$

## 8.2 二重积分的计算
**适合极坐标**
+ （1）适合用极坐标计算的被积函数
	+ 公式：
		+ $$f(x^2+y^2),f(\sqrt{x^2+y^2}),f(\frac yx),f(\frac xy)$$
	+ 原因：
		+ $\sqrt{x^2+y^2}$ 在直角坐标系下比较复杂，但是在极坐标下就代表 `ρ`
		+ $\frac yx$ 在极坐标系就是表示角度
+ （2）适合用极坐标的积分域
	+ $$x^{2}+y^{2}\leq R^{2};\quad\quad\quad r^{2}\leq x^{2}+y^{2}\leq R^{2};\quad\quad\quad\\x^{2}+y^{2}\leq2ax;\quad\quad\quad x^{2}+y^{2}\leq2by;$$
	+ 注意：
		+ 当圆心不在原点时，可以将 $x-x_0$ 设为 $\rho\sin\theta$，同理对 $y-y_0$
+ 其中，如果（1）和（2）发生矛盾，以（1）为主

**定理**：基于直角坐标系的二重积分计算
+  （1）先 `Y` 后 `X`：$$\int\int_D{f(x,y)d\sigma = \int_{a}^{b}[\int_{y_{1}(x)}^{y_{2}(x)}f(x,y)dy]dx}$$
	+ 区域：$\begin{aligned}\varphi_1(x)&\leq y\leq\varphi_2(x)\cdot\\a&\leq x\leq b\end{aligned}$
	+ 其中 $\varphi_1(x)\leq y\leq\varphi_2(x)$ 代表的是 x 的取值范围，是 x 关于 y 的函数，$\varphi_1(x)$ 就是实际的 y 等于的值； 
+ （2）先 `X` 后 `Y`：$$\iint_Df(x,y)\mathrm{d}\sigma=\int_c^ddy\int_{\psi_1(y)}^{\psi_2(y)}f(x,y)dx$$
	+ 区域：$\begin{aligned}\Psi(y)&\leq X\leq\Psi_2(y)\\c&\leq y\leq d\end{aligned}$
+ 确定积分限；
	+ 先 Y 后 X 时：
		+ `dy` 的积分上限与下限 `->` 从下往上画一条射线，射线的下端为 `dy` 积分下限，射线的上端为 dy 的积分上限；
		+ `dx` 的积分上限与下限 `->` 观察图像，看 x 的取值范围；
	+ 先 X 后 Y 时：
		+ `dx` 的积分上限与下限 `->` 从左往右画一条射线，射线的左端为 `dx` 积分下限，射线的上端为 `dx` 的积分下限；
		+ `dy` 的积分上限与下限 `->` 观察图像，看 `y` 的取值范围；

**定理**：基于极坐标的二重积分计算
+ $$\text{先 }\rho\text{ 后 }\theta\quad\iint_Df (x, y)\mathrm{d}\sigma=\int_\alpha^\beta d\theta\int_{\varphi_1 (\theta)}^{\varphi_2 (\theta)}f (\rho\cos\theta,\rho\sin\theta)\rho d\rho$$
+ 区域：$\begin{aligned}\varphi_1(0)&\leq p\leq\varphi_2(0)\\\alpha&\leq\theta\leq\beta.\end{aligned}$

**定理**：奇偶性
+ 若积分 `D` 关系 `Y` 轴对称，则函数关于 `X` 有奇偶性：
	+ $$\iint\limits_{D}f(x,y)d\sigma=\begin{cases}2\iint\limits_{D_{x\geq0}}f(x,y)\mathrm{d}\sigma;&f(-x,y)=f(x,y)\\0;&f(-x,y)=-f(x,y)\end{cases}$$
+ 若积分 `D` 关系 `X` 轴对称，则函数关于 `Y` 有奇偶性： 
	+ $$\iint\limits_{D}f(x,y)d\sigma=\begin{cases}2\iint\limits_{D_{y_{z_0}}}f(x,y)\mathrm{d}\sigma&f(x,-y)=f(x,y)\\0&f(x,-y)=-f(x,y)\end{cases}$$

**定理**：对称性
+ $$\text{若 }D\text{ 关于 }y=x\text{ 对称,则}\quad\iint_Df(x,y)\mathrm{d}\sigma=\iint_Df(y,x)\mathrm{d}\sigma $$
+ 或：
	+  $$\int\int_{D(x,y)} f(x,y)\mathrm{d}x\mathrm{d}y=\int\int_{D(u,v)} f(u,v)\mathrm{d}u\mathrm{d}v=\int\int_{D(y,x)} f(y,x)\mathrm{d}y\mathrm{d}x$$

## 8.3 三重积分
**定义**：三重积分
+ $\iiint_{\Omega}f(x,y,z)\mathrm{d}\mathbf{v}=\lim_{\lambda\to0}\sum_{k=1}^{n}f(\xi_{k},\eta_{k},\xi_{k})\Delta\nu_{k}$
+ 一个三元函数，在一个空间体 $\Omega$ 当中的积分；
+ $\Delta\nu_{k}$ 为第 k 个小区域的几何体的体积；

**计算**：直角坐标
+ 方法一：先一后二 $$\iiint_{\Omega}f(x,y,z)\mathrm{dv}=\iint_{D_{xy}}d\sigma\int_{z_{1}(x,y)}^{z_{2}(x,y)}f(x,y,z)dz$$
+ 方法二：先二后一 $$\iiint_{\Omega}f(x,y,z)\mathrm{d}\mathbf{v}=\int_{c_{1}}^{c_{2}}dz\iint_{D_{c}}f(x,y,z)dxdy$$

**计算**：柱坐标
+ 定义：柱坐标
	+ $$\begin{cases}x=r\cos\theta,&\quad0\leq r<+\infty,\\y=r\sin\theta,&\quad0\leq\theta\leq2\pi,\\z=z,&\quad-\infty<z<+\infty.\end{cases}$$
+ 图示：
	+ ![[Pasted image 20240521035217.png]]
+ 计算：
	+ 体积微元：$dv=\rho d\rho d\theta dz$
	+ $$\iiint_\Omega f(x,y,z)d\nu=\iiint_{\Omega}f(\rho\cos\theta,\rho\sin\theta,z)r\operatorname{d}r\operatorname{d}\theta\operatorname{d}z$$

**计算**：球坐标
+ 定义：球坐标
	+ $$\begin{cases}x=r\sin\varphi\cos\theta,&\quad0\leq r<+\infty,\\y=r\sin\varphi\sin\theta,&\quad0\leq\varphi\leq\pi,\\z=r\cos\varphi,&\quad0\leq\theta\leq2\pi.\end{cases}$$
+ 图示：
	+ ![[Pasted image 20240521040109.png]]
+ 计算：
	+ 体积微元：$dv=r^{2}\sin\varphi drd\varphi d\theta$
	+ $$\iiint_{\Omega}f(x,y,z)d\nu =\iiint_\Omega f (r\sin\varphi\cos\theta, r\sin\varphi\sin\theta, r\cos\varphi) r^2\sin\varphi\operatorname{d}r\operatorname{d}\varphi\operatorname{d}\theta$$
+ 适用：被积函数可以被写成 $f(\sqrt{x^2+y^2+z^2})$ 或者中心在原点的球体、球面、半球体、曲顶锥体 `->` 适合用球坐标

# Chapter 9：无穷级数 
## 9.1 常数项级数 
**解题步骤**
+ 第一步：判断级数类型
	+ 正项、交错、任意项
+ 第二步：根据级数，选择方法
	+ 正项级数 `->` 用敛散性的五类判别法，做判定；
	+ 交错级数 `->` 一个方法；
	+ 任意项级数 `->` 一个方法；
+ 第三步：如果无法做出判定，此时可以使用定义和性质来进行判定
	+ 定义和性质是适用于所有类型的级数的；

### 9.1.1 基本概念 
**定义**：常数项级数收敛
+ $u_{1}, u_{2},\cdots u_{n},\cdots$ 表示常数项，$S_{n}=u_{1}+u_{2}+\cdots+u_{n}$ 表示前 `n` 项的和；
+ 若：$$\lim_{n\to+\infty}S_{n}=\sum_{n=1}^\infty u_n$$
+ 则当前常数项数列为收敛的，若是没有极限，则是为发散的；

**性质**
+ 1. $如果\sum_{n=1}^{\infty}u_n 收敛于S，则\sum_{i=1}^{\infty}k u_n. 收敛于 kS$
+ 2. $如果\sum_{n=1}^{\infty}H_{n}和\sum_{n=1}^{\infty}U_{n}分别收敛于 h 和 u，则\sum_{n=1}^{\infty}(H_{n}\pm U_{n})也收敛于h+u$
+ 3.  在级数中去掉或加上**有限项**，敛散性不变，值可能会变化；
+ 4. $\sum u_n收敛，任意加括号后级数也收敛，且和不变$
+ 5. 级数收敛的必要条件：$\sum_{n=1}^\infty u_n\text{ 收敛 }\longrightarrow\lim_{n\to\infty}u_n=0$

**常用结论**
+ $$\sum_{n=1}^{+\infty}|b_{n|}收敛\rightarrow \sum_{n=1}^{+\infty}(b_{n})^{2}收敛$$

### 9.1.2 正项级数 
**定义**：正项级数的收敛性
+ 正项 $\sum u_n$ 收敛的充分必要条件是 ${S_n}$ 有界；
+ $$\sum_{n=1}^\infty u_n\text{ 收敛}\Leftrightarrow s_n\text{ 上有界}$$
**方法**：正项级数的五类方法
+ 方法分类：
	+ 1. 比较审敛法 
	+ 2. 比较法的极限形式 
	+ 3. 比值法 
	+ 4. 根值法
	+ 5. 积分判别法 
+ 方法选择：
	+ 第一类：方法 `1、2`
		+ 需要把当前的通项和其它已知通项进行比较；
		+ 优点： 
			+ 适用范围更广泛；
			+ 只要是方法 3、4 可以做出判定的，方法 `1、2` 都一定可以做出判定，只是可能做起来更不方便；
		+ 缺点： 
			+ 使用起来不方便；
	+ 第二类：方法 `3、4`
		+ 概念： 
			+ 只需要自己就可以进行判断；
		+ 优点： 
			+ 使用起来方便，不需要其他级数，自己就可以判断；
		+ 缺点： 
			+ 有些时候，级数很明显可以看出来时发散的，但却很难用方法证明出来；
			+ 即：适用范围窄；
+ 解题步骤：
	+ 1. 先观察是否可以直接看出来敛散性 `->` 规律； 
	+ 2. 在判断方法时，先考虑使用方法 `3、4`；
	+ 3. 如果做不出判定，再考虑 `1、2`；
+ 规律： 
	+ 三巨头：$$a^n\quad n!\quad n^n$$
	+ 如果这三巨头当中至少出现一个，通常就使用方法 `3、4`；
	+ 如果三巨头一个都不出现，此时经常出现的就是 $n^p$ 或者 $In{n}$ 的形式，此时就使用方法 `1、2`；

**方法一**：比较审敛法
+ 如果 $\sum U_n$ 和 $\sum V_n$ 都是正项级数，且 $u_n<v_n$：
+ $$\sum_{n=1}^\infty\nu_n\text{ 收敛 }\Rightarrow\sum_{n=1}^\infty u_n\text{ 收敛}$$
+ $$\sum_{n=1}^\infty u_n\text{ 发散 }\Rightarrow\sum_{n=1}^\infty\nu_n\text{发散}$$
+ 总结：
	+ 大的收敛，小的肯定收敛；
	+ 小的发散，大的肯定发散；
	+ 反过来都不行；
+ 使用方法：
	+ 使用之前，先进行初步判断；
	+ 如果初步判断其为收敛，则进行放大；
	+ 如果初步判断其为发散，将进行缩小；
+ 常用级数一： 
	+ $$\sum_{n=1}^\infty\frac1{n^p}  \quad\quad\quad\quad\quad  P>1时收敛，P<=1时发散$$ 
	+ 注意：
		+ `P=1` `->` 调和级数： $\sum\frac{1}{n}\quad 一定发散$ 
		+ 为什么 `P=1` 时是发散的?
	+ 收敛的本质：
		+ 决定级数是否收敛的不在于求和项是否是无穷的，甚至不在于求和的大小，而是在于求和项中通项趋向于 0 的速度；
		+ 通过速度比较并不能确定一个级数发散还是收敛，但是速度变化会带来本质的变化；
+ 常用级数二：
	+   $$\sum_{n=1}^\infty aq^n\left(a>0,q>0\right)\quad q<1\text{ 时收敛,当 }q\geq1\text{ 时发散}.$$
	+  等比级数是否收敛，只取决于其 `q` 的数值，即公比决定了其敛散性；

**方法二**：比较法的极限形式 
+ 设 $$\lim_{n\to\infty}\frac{u_n}{v_n}=l\left(0\leq l\leq+\infty\right)$$
+ 若：
	+ 1. $$若0<l<+\infty,\text{则}\sum_{n=1}^{\infty}u_{n}与\sum_{n=1}^{\infty}\nu_{n}{\text{同敛散}.}$$
	+ 2. $$\text{若 }l=0\text{,则}\sum_{n=1}^\infty\nu_n\text{收敛 }\Rightarrow\sum_{n=1}^\infty u_n\text{ 收敛,}\sum_{n=1}^\infty u_n\text{发散 }\Rightarrow\sum_{n=1}^\infty\nu_n\text{发散}$$
	+ 3. $$\text{若 }l=+\infty,\text{则}\sum_{n=1}^\infty\nu_n\text{发散}\Rightarrow\sum_{n=1}^\infty u_n\text{ 发散. }\sum_{n=1}^\infty u_n\text{收敛}\Rightarrow\sum_{n=1}^\infty\nu_n\text{ 收敛}$$

**方法三**：比值审敛法
+ 如果 $\sum U_n$ 是一个正项级数，则若 $$\lim_{n\to\infty}\frac{u_{n+1}}{u_{n}}=\rho$$
+ 如果 $\rho <1$，则 $\sum U_n$ 收敛；
+ 如果 $\rho >1$，则 $\sum U_n$ 发散；
+ 如果 $\rho =1$，则 $\sum U_n$ 无法判断，请使用其他方法；

**方法四**：根值法
+ $$\text{设}\lim_{n\to\infty}\sqrt[n]{u_n}=\rho\text{,则}\sum_{n=1}^\infty u_n\begin{cases}\text{收敛},&\rho<1,\\\\\text{发散},&\rho>1,\\\\\text{不一定},&\rho=1,\end{cases}$$

**方法五**：积分判别法
+ $$设f(x)在[1,+\infty)上单调减，非负的连续函数，且 a_{n}=f(n)，则\sum_{n=1}^{\infty}a_{n}\text{ 与 }\int_{1}^{+\infty}f(x)dx同敛散性$$
+ **例题**：
	+ 证明： 
		+ 级数 $\sum_{i=1}^\infty\frac1{n^p}$ 当 $p>1$ 时收敛，当 $p\leq1$ 时发散；
	+ 解析
		+ 设 $a_{n}=\frac{1}{n^{p}}=f(u),f(x)=\frac{1}{x^{p}}$
		+ 所以得到积分：$\int_{1}^{+\infty}\frac{dx}{x^{p}}$

### 9.1.3 交错级数 
**定义**：交错级数 
+ $$\sum_{n=1}^\infty(-1)^{n-1}u_n,u_n>0$$
+ $u_{1}-u_{2}+u_{3}-u_{4}+u_{5}-u_{6}+\cdots$；
+ $-u_{1}+u_{2}-u_{3}+u_{4}-u_{5}+u_{6}\cdots$；


**注意**
+ 如果项数是无穷项时，**小括号不能随便加**，**顺序也不能随便换**；
+ 比如：
	+ $1-1+1-1+1-1+1-1+1-1+1-1+1......$
	+ 如果是奇数项 -> 结果为 1；
	+ 如果时偶数项 -> 结果为 0；
+ 如果加括号
	+ $(1-1)+(1-1)+(1-1)+(1-1)+......$
	+ 这样对无穷项加括号，可能会有问题，因为不清楚是奇数项还是偶数项；


**定理**： #莱布尼茨准则
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>当前有交错级数 $\sum_{n=1}^{+\infty}\left(-1\right)^{n-1}u_{n}$，当：
> 1）$u_{n}\geq u_{n+1}$：单调减
> 2）$\lim_{n\to\infty}u_{n}=0$
> 则可得到 $\sum_{n=1}^{+\infty}\left(-1\right)^{n-1}u_{n}$ 级数收敛，`S` `<=` $u_1$，且 $|r_{n}|\leq u_{n+1}$

**解释**
+ 注意：
	+ 要求：
		+ 1）$u_{n}\geq u_{n+1}$：单调减
		+ 2）$\lim_{n\to\infty}u_{n}=0$
	+ 这两个要求是交错级数收敛的**充分条件**，也就是说这两个里面如果有一个不成立，也有可能交错级数收敛；
+ 前提：
	+ 使用莱布尼茨定理之前，需要保证当前是交错级数；
	+ 后一项比前一项越来越小；
	+ 且 $u_n$ 是往 0 逼近的；


### 9.1.4 任意项级数 
**任意项级数概念**
+ 特点： 
	+ 有正项、有负项；
	+ 并且正项、负项都得是无限项；
+ 任意项： $u_{1}+u_{2}+u_{3}+u_{4}+\cdots$，并且 $u_n$ 的正负不知道；
+ 正项级数：$|u_{1}|+|u_{2}|+|u_{3}|+|u_{4}|+\cdots$ ，每项都取绝对值；
	+ 这种为绝对值级数；

**判断方法**
+ **原则**：把新问题化成老问题 `->` 把一个变号的级数，化成一个正项级数 `->` 通项加一个绝对值 `->` 这个新的正项级数收敛时，任意项级数也收敛；


**定义**： #绝对收敛与条件收敛
> <font color="#ccc1d9">描述：</font>
> 1. 绝对收敛：如果加了绝对值的 $\sum|u_{n}|$ 收敛，则称 $\sum u_n$ 收敛；
> 2. 条件收敛：如果 $u_n$ 是收敛的，$\sum|u_{n}|$ 是发散的，则称 $\sum u_n$ 是条件收敛的； 
> 具体情况：
> (1) 若 $\sum^{\infty}_{n=1}=|a_n|$ 收敛，则 $\sum^{\infty}_{n=1}=a_n$ 必收敛，此时称 $\sum^{\infty}_{n=1}a_n$ 绝对收敛 
> (2) 若 $\sum^{\infty}_{n=1}=a_n$ 收敛，$\sum^{\infty}_{n=1}=|a_n|$ 发散，则称 $\sum^{\infty}_{n=1}a_n$ 条件收敛

**解释**
+ 绝对收敛    
	+ $\sum|u_{n}|$ 收敛
	+ $\sum u_n$   收敛
+ 条件收敛
	+ $\sum|u_{n}|$ 发散
	+ $\sum u_n$   收敛

**举例**
+ $\sum(-1)^{n-1}\frac{1}{n}$：交错调节级数 -> 收敛的；
+ $\sum(-1)^{n}\frac{1}{n^{3}}$：是绝对收敛的；

**基本结论**
+ 1. 绝对收敛的级数，一定收敛 `->` 即：$\sum^{\infty}_{n=1}|a_n|$ 收敛 `->` $\sum^{\infty}_{n=1}a_n$ 收敛；
+ 2. 条件收敛的级数的所有正项（或负项）构成的级数，一定发散 `->` $$\sum_{n=1}^\infty u_n\text{ 条件收敛 }\Rightarrow\sum_{n=1}^\infty\frac{u_n+|u_n|}2\text{ 和 }\sum_{n=1}^\infty\frac{u_n-|u_n|}2\text{ 发散}.$$

**定理**： #任意项级数的绝对收敛
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果每项都加绝对值 $\sum_{n=1}^{+\infty}|u_{n}|$ 以后，它是收敛的，则它原来的级数 $\sum_{n=1}^{+\infty}u_{n}$ 也是收敛的；

**解释**
+ 更简单的理解：
	+ 全是正数（加绝对值）的情况下都可以收敛，那他原本有正有负的情况下就更应该是收敛的；

**定理**： #任意项级数发散收敛判断
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $\sum_{n=1}^{+\infty}u_{n}=u_{1}+u_{2}+u_{3}+\cdots$ 是任意项级数，且 $\lim_{n\to+\infty}\left|\frac{u_{n+1}}{u_{n}}\right|=l$
> 1）当 $l$ < 1 时，$\sum u_n$ 绝对收敛；
> 2）当 $L>1(+\infty)$ 时，$\sum u_n$ 发散；
> 3）当 L =1 时，无法判断；

**解释**
+ 如果 L>1，则原本的级数就是发散的；

## 9.2 幂级数
### 9.2.1 幂级数基本概念
**数列**：每一项只和 n 有关
+ 数列： $u_{1},u_{2},\cdots,u_{n}$
+ 无穷级数：$u_{1}+u_{2}+\cdots+u_{n}+\cdots$

**函数列**：每一项和 n 以及 $x$ 有关
+ 假设 x 在区间 $I$ 上；
+ 函数列： $u_{1}(x), u_{2}(x), u_{n}(x),\cdots$
+ 函数项无穷级数：$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 

**定义**： #幂级数
> <font color="#ccc1d9">描述：</font> 
> 常见形式： $$\sum_{n=0}^\infty a_nx^n=a_0+a_1x+a_2x^2+\cdots+a_nx^n+\cdots $$
> 一般形式：$$\sum_{n=0}^\infty a_n(x-x_0)^n=a_0+a_1(x-x_0)+\cdots+a_n(x-x_0)^n+\cdots $$

**解释**
+ 概念：
	+ 每一项都是 `x` 的正整数幂：幂级数： $a_{0}a_{1},a_{2}x^{2}\cdots a_{n}x^{n}\cdots$
	+ 幂级数其实是函数项级数的最简单的一种，$x^{n}$ 就是 x 的函数，$a_n$ 就是一列数；
	+ $a_0,a_1,a_2...a_n$ 称之为系数；
+ 补充：
	+ 一般研究常见形式，因为一般形式可以用 $x-x_0=t$ 化成常见形式；

**定义**： #收敛点与发散点
> <font color="#ccc1d9">描述：</font>
> 1. 如果 $x_{0}\in I$ 时，$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 收敛，则称 $x_o$ 为收敛点，如果是一段区间则称之为收敛域；
> 2. 如果 $x_{0}\in I$ 时，$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 发散，则称 $x_o$ 为发散点，如果是一段区间则称之为发散域；
> 3. $S\left (x\right)=u\left (x\right)+u_{2\left (x\right)}+\cdots+u_{n}\left (x\right)+\cdots$ 称之为和函数，$\lim_{n\to\infty}S_n(x)=S\left(x\right)$；

**解释**
+ 一般就是求两个问题：收敛域是什么？和函数是什么？

**举例**
+ $1+x+x^{2}+x^{3}+\cdots+x^{n}+\cdots$
+ 此时：
	+ $|x|<1\text{时，收敛城(-1,1)}\frac{a}{1-q}=\frac{1}{1-x}$
	+ $|\times|\geq1 时，发散域(-\infty,-1)|U[1,+\infty]$

### 9.2.2 幂级数展开
**定理**： #阿贝尔定理 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 
> $$\sum_{n=0}^{+\infty}a_nx ，当x=x_0 时收敛,|x|<|x_0|时幂级数绝对收敛$$
> $$\sum_{n=0}^{+\infty}a_nx ，当x=x_0 时发散,|x|>|x_0|时幂级数发散$$

**解释**
+ 定理的作用：
	+ 揭示了当前幂级数的收敛、发散的域的结构 `->` 将求收敛域的问题、转化成了求整个区间一般长度的问题 `->` 也就是求收敛半径 `R` ；
+ 绝对收敛：
	+ 在 $|x|<|x_0|$ 时，此时在这个区间内的点，也都收敛 `->` 离原点更近的点收敛；
+ 发散：
	+ 在 $|x|>|x_0|$ 时，此时在这个区间外的点，也都收敛 `->` 离原点更远的点发散；
+ 总结：
	+ 1. 收敛点和发散点的分界点 `->` 就是**收敛半径 R**
	+ 2. 两个级数 $\sum_{n=0}^{+\infty}a_n{(x+2)}$ 和 $\sum_{n=0}^{+\infty}a_n{(x-3)}$ ，如果它们的 $a_n$ 一样，则它们有共同的收敛半径 `R`； 
+ 注意： 
	+ 收敛区间不需要关注端点；
	+ 收敛域需要关注端点；

**补充**：收敛区间和收敛域
+ 收敛区间：
	+ $(-R,+R)$
+ 收敛域：
	+ 包括端点在内：$\pm R$
	+ 分别判断两个端点的值后，得到的区间；

**补充**：关于 $x$ 不等于 $x_0$ 时的收敛域
+ 前提：
	+ 根据 `<总结-1>` 可知，$\sum_{n=0}^{+\infty}a_n{(x+2)}$ 和 $\sum_{n=0}^{+\infty}a_n{(x-3)}$ 的收敛半径 `R` 一样；
+ 概念：
	+ 收敛区间： 
		+ 对 $\sum_{n=0}^{+\infty}a_n{(x+2)}$ 而言，其中心在 `x=-2` 点，因此假设其收敛点在 `x=0` 处时，其收敛半径为 `0-(-2)=2` ，因此其收敛区间就是：
		+ $$收敛区间：(x_0-R,x_0+R)\rightarrow (-2-2,-2+2)\rightarrow (-4,0)$$
	+ 端点收敛性不变性：
		+ 因为两个级数的 $a_n$ 项相同，所以这两个级数的收敛域的两个端点同敛散性；

**定理**： #幂级数的收敛情况
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 幂级数  $\sum_{n=0}^{+\infty}a_nx$ 的收敛性有且仅有三种可能：
> （1）对任何 x 属于 $(-\infty ,+\infty)$ 都收敛；
> （2）只在 $x=0$ 处收敛；
> （3）存在一个正数 `R` 当 $|x| < R$ 时绝对收敛，当 $|x|>R$ 时发散； 
> 注意：若幂级数 $\sum_{n=0}^{+\infty}a_nx$ 在点 $x=x_0$ 处条件收敛，则点 $x_0$ 必为该幂级数收敛区间 $(-R,R)$ 的一个端点；

**定理**： #收敛半径判断
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$若\lim_{n\to\infty}\left|\frac{a_{n+1}}{a_{n}}\right|=\rho，则 R = \frac{1}{{\rho}}$$
> 即：此时有三种情况：$$R=\begin{cases}\frac{1}{\rho},&\rho\neq0\\+\infty,&\rho=0\\0,&\rho=+\infty\end{cases}$$

**解释**
+ 注意： 
+ 1. 此定理只能单方向使用；
+ 2. 收敛区间是不管端点的，即 $(-R,R)$


**定理**： #收敛半径判断：基于根式
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\text{如果 }\lim_{n\to\infty}\sqrt[n]{|a_n|}=\rho,\text{则}\quad R=\frac1\rho $$

**解释**
+ 基于根值法推导而来；

**性质**：幂级数的有理运算性质
+ 前提：
	+ 设
	+ 1.  $\sum_n^{\infty}a_nx^n$ 的收敛半径为 $R_1$
	+ 2.  $\sum_n^{\infty}b_nx^n$ 的收敛半径为 $R_2$
	+ 令 $R=\min\{R_1,R_2\}$，则当 $x\in(-R,R)$ 时：
+ 运算性质：
	+ （1）加法：$$\sum_{n=0}^\infty a_nx^n\pm\sum_{n=0}^\infty b_nx^n=\sum_{n=0}^\infty(a_n\pm b_n)x^n$$
	+ （2）乘法：$$(\sum_{n=0}^\infty a_nx^n)\cdot(\sum_{n=0}^\infty b_nx^n)=\sum_{n=0}^\infty c_nx^n$$ 
		+ 且：$c_n=a_0b_n+a_1b_{n-1}+\cdots+a_nb_0$ 
	+ （3）除法：$$\frac{\sum_{n=0}^\infty a_nx^n}{\sum_{n=0}^\infty b_nx^n}=\sum_{n=0}^\infty c_nx^n$$

**性质**：幂级数的分析性质
+ 前提：
	+ 若 $\sum_{n=0}^{+\infty}a_{n}x^{n}$ 的收敛半径是 `R`，和函数为 $S(x)$，则：
+ 分析性质：
	+ （1）连续性：
		+ $S(x)$ 在它的收敛域上 $I$ 是连续的；
	+ （2）可导性：
		+ $S(x)$ 在 $(-R,R)$ 上可导，且可以逐项求导，半径不变，即：
			+ $$S^{\prime}(x)=\left(\sum_{n=0}^\infty a_nx^n\right)^{\prime}=\sum_{n=0}^\infty(a_nx^n)^{\prime}=\sum_{n=0}^\infty na_nx^{n-1}$$
		+ 注意：这里面级数求导之后，收敛半径没有变化，还是 R，并且通项当中还多了一个 $n$
	+ （3）可积性：
		+ 若 $\sum_{n=0}^{\pm\infty}a_{n}x^{n}$ 的和函数 $S(x)$ 在 $I$ 上是可积的，且可以逐项积分，则：
			+ $$\int_{0}^{x}S(x)\operatorname{d}x=\int_{0}^{x}\sum_{n=0}^{\infty}a_{n}x^{n}\operatorname{d}x=\sum_{n=0}^{\infty}\int_{0}^{x}a_{n}x^{n}\operatorname{d}x=\sum_{n=0}^{\infty}\frac{1}{n+1}a_{n}x^{n+1}$$
		+ 注意：逐项求积分后的幂级数，与原幂级数的收敛半径是相同的；

**题型**：求收敛半径
+ 两种方法：
	+ 方法一：使用收敛半径判定法
	+ 方法二：使用收敛半径根值判定法
+ 注意：缺项时
	+ 缺项：$x^{2n-1}$ ，不是 $x^n$
	+ 缺项时不能直接使用公式，如果是 $x^{2n+b}$ ，则此时都需要将根值法算得的 `R` 开一个 $\frac{1}{2}$ 次方；

**题型**：求收敛区间
+ 方法：
	+ 想要求得收敛区间，需要先求得收敛半径；

**题型**：求端点的收敛性
+ 方法：
	+ 分别将端点的 $x=\pm x_0$ 代入进去，得到关于 n 的函数式，即：当前级数的通项。此时解题方法和常数项级数一致，根据其是正项、交错级数、任意项级数，选择方法，判定；
 
**题型**：判断任意一点的收敛性
+ 方法：
	+ 先求出当前幂级数的收敛半径（经常要使用阿贝尔定理），然后根据收敛区间，判断任意一点是否在区间内，即可得到收敛性；

### 9.2.3 函数展开成幂级数 
**为什么需要展开成幂级数**
+ 原因：
	+ 有些函数不是初等函数、不可以直接使用积分求出来它的值，比如 $e^{x^2}$ 其无法直接求出其原函数；
	+ 此时可以考虑：将其展开成幂级数，因为幂级数的每一项都很简单，因此可以被处理；
+ 举例：比如需要求 $e^{0.2}$ 等于多少
	+ 直接求很难算出来；
	+ 但利用展开后的幂级数，计算出来就很简单： $e^{x}=1+x+\frac{x^{2}}{2!}+\frac{x^{3}}{3!}+\cdots+\frac{x^{n}}{n!}+$
	+ 后续的项可以近似得到，一般就用个三项、四项就够了；


**定理**： #函数的幂级数展开
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 如果函数 $f(x)$ 在区间 $(x_0-R,x_0+R)$ 上，能展开为 $x-x_0$ 的幂级数 $f(x)=\sum_{n=0}^{+\infty} a_n(x-x_0)^n$ 则，其展开式是唯一的；
> 并且称其为 $f(x)$ 在 $x=x_0$ 处的**泰勒级数**：$$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$$

**解释**
+ 如果 $\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$ 可以收敛于 $f(x)$，则称其可以展开；


**定理**： #泰勒级数的收敛性
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 设 $f(x)$ 在 $x=x_0$ 处任意阶可导，则：
> $$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n 在 (x_0-R,x_0+R) 上收敛于 f(x)\Leftrightarrow\lim_{n\to\infty} R_n(x)=0.$$
> 其中：$$\begin{aligned}&R_n(x)=\frac{f^{(n+1)}(\xi)}{(n+1)!}(x-x_0)^{n+1}\text{ 为 }f(x)\text{ 在 }x_0\text{ 处的泰勒公式}\\&f(x)=\sum_{k=0}^n\frac{f^{(k)}(x_0)}{k!}(x-x_0)^k+R_n(x)\end{aligned}$$
> 所以当 $R_n(x)$ `->` `0` 时，$f(x)$ 趋向于泰勒级数：$\sum_{n=0}^\infty\frac{f^{(n)}(x_0)}{n!}(x-x_0)^n$，即收敛于唯一的级数；

**补充**：几个常用的展开式
+ 直接展开法：
	+ （1）$$\frac1{1-x}=1+x+x^2+\cdots+x^n+\cdots =\sum^{\infty}\limits_{n=0}x^n\quad (-1<x<1)$$
	+ （2）$$\frac1{1+x}=\sum_{n=0}^\infty(-1)^nx^n,|x|<1$$
	+ （3）$$\sin x=x-\frac{x^3}{3!}+\cdots+\frac{(-1)^{n}x^{2n+1}}{(2n+1)!}+\cdots=\sum_{n=0}^{\infty}\frac{(-1)^n}{(2n+1)!}x^{2n+1} \quad(-\infty<x<+\infty)$$
		+ 注意：求和下标从 0 开始，`(-1)` 是指数是 `n`；
	+ （4） $$e^x=1+x+\frac{x^2}{2!}+\cdots+\frac{x^n}{n!}+\cdots \quad (-\infty<x<+\infty)=\sum^{\infty}\limits_{n=0}\frac{x^n}{n！}$$
+ 间接展开法：
	+ （1）`cosx` 的展开式，是由 `sinx` 的展开式逐项求导而的来的：$$\cos x=1-\frac{x^2}{2!}+\cdots+\frac{(-1)^{n-1}x^{2n}}{(2n)!}+\cdots=\sum_{n=0}^{\infty}\frac{(-1)^n}{(2n)!}x^{2n}   \quad(-\infty<x<+\infty)$$
	+ （2）`In(1+x)` 的展开式：$$\ln(1+x)=x-\frac{x^2}2+\cdots+\frac{(-1)^{n+1}x^n}n+\cdots=\sum_{n=1}^{\infty}\frac{(-1)^{n+1}}{n}x^{n}\quad(-1<x\leq1)$$
	+ （3）`(1+X)的α次方` 的展开式，也是间接得到的：$$\left(1+x\right)^\alpha=1+\alpha x+\frac{\alpha(\alpha-1)}{2!}x^2+\cdots+\frac{\alpha(\alpha-1)\cdots(\alpha-n+1)}{n!}x^n+\cdots \quad(-1<x<1)$$
	+ (4) $$\sum_{n=1}^{\infty}\frac{x^{n}}n=-\ln(1-x)\quad(-1\leq x<1)$$
+ 注意： 
	+ 关于下标：除了 `In(1+x)` 是从 `n=1` 开始的，其他都是从 `n=0` 开始的； 
	+ 关于 $(-1)^{n}$ 和 $(-1)^{n+1}$：只有 `In(1+x)` 是 `n+1` ，其他都是从 `n`；
	+ 关于阶乘：除了 `In(1+x)` 的分母是非阶乘，其他带分母的都是阶乘，并且阶乘部分和幂指部分一致；
	+ 关于收敛域：三角函数和 $e^{x}$ 是负无穷到正无穷，其他都是 `-1` 到 `+1`，并且 `In(1+x)` 是小于等于 `+1`；


## 9.3 傅里叶级数 

**定义**： #傅里叶系数
> <font color="#ccc1d9">描述：</font> $$a_{n}=\frac1\pi\int_{-\pi}^xf(x)\cos nx\mathrm{d}x\quad n=0,1,2\cdots\quad\quad\\b_{n}=\frac1\pi\int_{-\pi}^xf(x)\sin nx\mathrm{d}x\quad\quad n=1,2\cdots $$

**解释**
+ 可以利用上述公式，来求给定 n 式的系数；

**定义**： #傅里叶级数
> <font color="#ccc1d9">描述：</font> `f` 的傅里叶级数：$$f(x)\sim\frac{a_0}2+\sum_{n=1}^\infty(a_n\cos nx+b_n\sin nx)$$

**解释**
+ 概念：
	+ 以上式子是否能展开、取决于上述式子中的 `~` 是否能写成等号；
	+ 而其是否能展开、需要使用收敛定理来判断；
+ 解释：
	+ `~`
		+ 意味着除开某些有限点外（间断点、端点），其他点都符合公式中的性质；
	+ $\frac{a_0}2$
		+ 在波动当中，表示直流分量；
	+ $(a_n\cos nx+b_n\sin nx)$：
		+ 在波动当中，表示交流分量；
		+ 注意：偶函数展开式只有余弦项，奇函数展开式只有正弦项；


**定理**： #狄利克雷定理
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 设 $f(x)$ 在 $[-\pi,\pi]$ 上连续或有有限个第一类间断点，且只有有限个极值点，则 $f(x)$ 的傅里叶级数在 $[-π,π]$ 上处处收敛，且收敛于： 
> $$1)\quad S(x)=f(x)\quad\text{当}x\text{ 为 }f(x)\text{ 的连续点}.$$
> $$2)\quad S(x)=\frac{f(x^-)+f(x^+)}2\quad\text{当 }x\text{ 为 }f(x)\text{ 的间断点}.$$
> $$3)\quad S(x)=\frac{f((-\pi)^+)+f(\pi^-)}2\quad\text{当 }x=\pm\pi.$$

**概念介绍**：周期为 $2\pi$ 的函数展开
+ （1）在 $[-\pi,+\pi]$ 上展开：一般展开
	+ $$a_{n}=\frac1\pi\int_{-\pi}^xf(x)\cos nx\mathrm{d}x\quad n=0,1,2\cdots\quad\quad\\b_{n}=\frac1\pi\int_{-\pi}^xf(x)\sin nx\mathrm{d}x\quad\quad n=1,2\cdots $$
+ （2）在 $[-\pi,+\pi]$ 的展开：奇偶函数的展开
	+ 1. $f(x)$ 为奇函数：
		+ $$a_{n}=0\quad n=0,1,2\cdots\quad\quad\\b_{n}=\frac2\pi\int_{0}^xf(x)\sin nx\mathrm{d}x\quad\quad n=1,2\cdots $$
		+ 解释：因为 $cosx$ 是偶函数，并且在 $a_n$ 中，所以当 $f(x)$ 为奇函数时，`奇函数*偶函数=奇函数`，所以 $a_n$ 变为 0，$b_n$ 变为两倍。其他情况同理；
	+ 2. $f(x)$ 为偶函数：
		+ $$a_{n}=\frac2\pi\int_{0}^xf(x)\cos nx\mathrm{d}x\quad n=0,1,2\cdots\quad\quad\\b_{n}=0\quad\quad n=1,2\cdots $$
+ （3）在 $[0,+\pi]$ 上展开：展开为正弦或余弦
	+ 分析：
		+ 这种是在半个周期上的展开，所以在分析时，需要做**延拓**；
		+ 奇函数展开：只有正弦项。因为如果只给了 $[0,+\pi]$ ，则如果需要在 $[-\pi,+\pi]$ 上做奇函数展开、只有正弦项 `->` **奇延拓**；
		+ 在展开为正弦时，理论上需要做奇延拓，但实际上直接使用奇函数的展开式即可；
		+ 同理偶延拓；
	+ 1. 展开为正弦：
		+ $$a_{n}=0\quad n=0,1,2\cdots\quad\quad\\b_{n}=\frac2\pi\int_{0}^xf(x)\sin nx\mathrm{d}x\quad\quad n=1,2\cdots $$
	+ 2. 展开为余弦：
		+ $$a_{n}=\frac2\pi\int_{0}^xf(x)\cos nx\mathrm{d}x\quad n=0,1,2\cdots\quad\quad\\b_{n}=0\quad\quad n=1,2\cdots $$

**概念介绍**：周期为 $2l$ 的函数展开
+ （1）在 $[-l,+l]$ 上展开
	+ $$a_n=\frac1l\int_{-l}^lf(x)\cos\frac{n\pi x}l\mathrm{d}x\quad\quad n=0,1,2\cdots\quad\quad \\b_n=\frac1l\int_{-l}^lf(x)\sin\frac{n\pi x}l\mathrm{d}x\quad\quad n=1,2\cdots $$
+ （2）在 $[-l,+l]$ 上展开：奇偶函数
	+ $$\text{i)}f(x)\text{ 为奇函数}.\quad\quad \\a_n=0,n=0,1,2\cdots\quad\quad \\b_n=\frac2l\int_0^lf(x)\sin\frac{n\pi x}l\mathrm{d}x\quad\quad n=1,2\cdots $$
	+ $$\begin{aligned}&\text{ii)}f(x)\text{ 为偶函数}.\\&{a_n}=\frac2l\int_0^lf(x)\cos\frac{n\pi x}l\mathrm{d}x&&n=0,1,2\cdots\\&b_{n}=0&&n=1,2\cdots\end{aligned}$$
+ （3）在 $[0,l]$ 上展开：展开为正弦或余弦
	+ $$\begin{aligned}&\text{i)展为正弦}\\&a_{n}=0,&&n=0,1,2\cdots\\&b_{n}=\frac2l\int_0^lf(x)\sin\frac{n\pi x}l\mathrm{d}x&&n=1,2\cdots\end{aligned}$$
	+ $$\begin{aligned}&\text{ii)展为余弦.}\\&a_{n}=\frac{2}{l}\int_{0}^{l}f(x)\cos\frac{n\pi x}{l}\mathrm{d}x&n=0,1,2\cdots\\&b_{n}=0&n=1,2\cdots\end{aligned}$$

# Chapter 10：向量代数与空间几何
## 10.1 向量代数
### 10.1.1 数量积
**定理**： #向量代数的数量积
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> $$1\text{)几何表示: }\mathbf{a}\cdot\mathbf{b}=\mid\mathbf{a}\mid\mid\mathbf{b}\mid\cos\alpha $$
> $$2\text{)代数表示:}\quad\mathbf{a}\cdot\mathbf{b}=\mathbf{a}_xb_x+\mathbf{a}_yb_y+\mathbf{a}_zb_z$$
> $$3\text{)运算规律:}\quad 交换律：\mathbf{a}\cdot\mathbf{b}=\mathbf{b}\cdot\mathbf{a} \quad \text{分配律: }\mathbf{a\cdot(b+c)=a\cdot b+a\cdot c}$$
> $$4\text{)几何应用:}\quad 求模：|\mathbf{a}|=\sqrt{\mathbf{a}\cdot\mathbf{a}}\cdot\mathbf{a} \quad \text{求夹角: }\cos\alpha=\frac{\mathbf{a}\cdot\mathbf{b}}{|\mathbf{a}||\mathbf{b}|}\quad \text{判定两向量垂直:}\mathbf{a\perp b\Leftrightarrow a\cdot b=0}$$

### 10.1.2 向量积
**定理**： #向量代数的向量积
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> $1. \text{几何表示:}\quad\mathbf{a}\times\mathbf{b}\text{ 是一向量}.\quad\text{模}:\mid\mathbf{a}\times\mathbf{b}\mid=\mid\mathbf{a}\mid\mid\mathbf{b}\mid\sin\alpha$
> $2. \text{代数表示:}\quad{\mathbf{a}\times\mathbf{b}}=\begin{vmatrix}\mathbf{i}&\mathbf{j}&\mathbf{k}\\a_x&a_y&a_z\\b_x&b_y&b_z\end{vmatrix}$
> $3. i) a\times b= - ( b\times a) \quad ii)分配律：a\times(b+c)=a\times b+a\times c$
> $4. 运算规律：i)求同时垂直于 a 和 b 的向量: a×b\quad ii)求以 a 和 b 为邻边的平行四边形面积:S=|a×b|\quad iii)判断两向量平行：\mathbf{a//b}\Leftrightarrow\mathbf{a\times b}=0$

**解释**
+ 几何表示 `->` 右手法则 `->` 垂直于 $a,b$ 向量的一个直线；
+ 注意：
	+ 数量积满足交换律，向量积不满足交换律； 

### 10.1.3 混合积
**定理**： #向量代数的混合积
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 
> 基本表述：$\left[ abc \right] = (a \times b) \cdot c$
> 定义： $$\ a = a_xi + a_yj + a_zk \\ b = b_xi + b_yj + b_zk \\ c = c_xi + c_yj + c_zk$$
> 性质：
> （1）$$(a\times b)\cdot c = a\cdot(b\times c) = b \cdot (c\times a)$$
> $$轮换对称性：(abc)=(bca)=(cab)\quad 交换变号：(\mathbf{abc})=-(\mathbf{acb})$$
> （2）$$\begin{aligned}(a\times b)\cdot c=-(b\times a)\cdot c\\(a\times b)\cdot c=-(c\times b)\cdot a\\(a\times b)\cdot c=-(a\times c)\cdot b\end{aligned}$$
> （3）$$a\text{、}b\text{、}c\text{三向量共面}\Leftrightarrow[abc]=0$$
> 几何意义：
> 1. 向量的混合积 $[abc]=(a\times b)\cdot c$ 的绝对值在数值上等于以向量 a、b、c 为棱的平行六面体的体积
> 2. $V_\text{平行六面体}=|\mathrm{(abc)}|$

## 10.2 空间平面与直线 

### 10.2.1 平面方程
**定义**： #平面方程
> <font color="#ccc1d9">描述：</font>
> $1\text{)一般式:}\quad Ax+By+Cz+D=0.\quad\mathbf{n}=\{A,B,C\}$
> $2\text{)点法式:}\quad A(x-x_0)+B(y-y_0)+C(z-z_0)=0$
> $3\text{)截距式:}\quad\frac xa+\frac yb+\frac zc=1$

### 10.2.2 直线方程
**定义**： #直线方程
> <font color="#ccc1d9">描述：</font>
> $$1)\text{一般式:}\quad\begin{cases}A_1x+B_1y+C_1z+D_1=0\\A_2x+B_2y+C_2z+D_2=0\end{cases}$$
> $$2)\text{对称式:}\quad\frac{x-x_0}l=\frac{y-y_0}m=\frac{z-z_0}n$$
> $$3)参数式：x=x_0+lt,y=y_0+mt,z=z_0+nt.$$

### 10.2.3 距离关系
**核心**：平面 `->` 看法线向量；直线 `->` 看方向向量

**概念**：点到面的距离
+ 点 $(x_0,y_0,z_0)$ 到平面 $Ax+By+Cy+D=0$ 的距离
+ $$d=\frac{|Ax_0+By_0+Cz_0+D|}{\sqrt{A^2+B^2+C^2}}$$
 
**概念**：点到直线距离 
+  $\text{点 }({x_0,y_0,z_0})\text{ 到直线 }\frac{x-x_1}l=\frac{y-y_1}m=\frac{z-z_1}n$
+ $$d=\frac{|\{x_1-x_0,y_1-y_0,z_1-z_0\}\times\{l,m,n\}|}{\sqrt{l^2+m^2+n^2}\quad J}$$

## 10.3 曲面与空间曲线
### 10.3.1 基本概念

**定义**： #空间曲面
> <font color="#ccc1d9">描述：</font> $$F(x,y,z)=0\quad\text{或 }z=f(x,y)$$

**举例**：$x+y+z=1$
+ 图示：
	+ ![[Pasted image 20240523230111.png]]
**定义**： #空间曲线
> <font color="#ccc1d9">描述：</font> $$\text{i)参数式:}\quad\begin{cases}x=x(t)\\y=y(t)\\z=z(t)\end{cases}\quad\text{ii)一般式:}\begin{cases}F(x,y,z)=0\\G(x,y,z)=0\end{cases}$$

**补充**：为什么空间曲面只要一个方程确定，而空间曲线要两个
+ 核心：
	+ 一个方程减少一个自由度；
	+ 曲面有两个自由度，而曲线只有一个；
	+ 因此空间曲线的一般式是关于 `xyz` 的两个方程；

### 10.3.2 常见曲面
**曲面一**：`旋转面` `->` 一条平面曲线绕平面上一条直线旋转
+ 设 $L$ 是 $yoz$ 平面上一条曲线，其方程是：$\begin{cases}f({y},z)=0\\x=0\end{cases}$
+ （1）$L\text{ 绕 }(y)\text{轴旋转所得旋转面方程为}\quad f(y,\pm\sqrt{x^2+z^2})=0.$
+ （2）$L绕 z 轴旋转所得旋转面方程为：$

**曲面二**：柱面 `->` 平行于定直线并沿定曲线移动的直线 L 形成的轨迹;
+ $准线为\Gamma:\begin{cases}f(x,y)=0\\z=0\end{cases}，母线平行于z轴的柱面方程为f(x,y)=0$ 
+ $准线为\Gamma:\begin{cases}F(x,y,z)=0\\G(x,y,z)=0&\end{cases}，母线平行于z轴的柱面方程为H(x,y)=0$
+ 图示：锥面 $z=\sqrt{x^{2}+y^{2}}$  在柱面 $x^{2}+y^{2}\le2x$ 的区域上：
	+ 锥面：
		+ ![[Pasted image 20240523231234.png]]
	+ 柱面：
		+ ![[Pasted image 20240523231044.png]]
	+ 三维：
		+ ![[Pasted image 20240523231108.png]]


**曲面三**：二次曲面
+ $$\text{椭圆锥面 }\frac{x^2}{a^2}+\frac{y^2}{b^2}=z^2;$$
+ $$\text{椭球面}\quad\frac{x^2}{a^2}+\frac{y^2}{b^2}+\frac{z^2}{c^2}=1;$$
+ (3)  单叶双曲面 $$\frac{x^{2}}{a^{2}}+\frac{y^{2}}{b^{2}}-\frac{z^{2}}{c^{2}}=1$$
+ (4)  双叶双曲面 $$\frac {x^{2}}{a^{2}}- \frac {y^{2}}{b^{2}}- \frac {z^{2}}{c^{2}}= 1$$
+ (5)  椭圆抛物面 $$\text{椭圆抛物面}\quad\frac{x^2}{a^2}+\frac{y^2}{b^2}=z;$$
**曲面四**：空间曲面投影
+ $q曲线\Gamma:\begin{cases}F(x,y,z)=0\\G(x,y,z)=0\end{cases}在xoy面上的投影曲线方程为：\begin{cases}H(x,y)=0\\z=0\end{cases}$


# Chapter 11：多元积分学及其应用
## 11.1 第一类曲线积分 
### 11.1.1 对弧长的曲线积分
**定义**： #平面上对弧长的线积分
> <font color="#ccc1d9">描述：</font> $$\int_{L}f(x,y)ds=\lim_{\lambda\to0}\sum_{i=1}^{n}f(\xi_{i},\eta_{i})\Delta s_{i}$$

**解释**
+ 一个二元函数，沿着一个二维的曲线段的积分；
+ 把曲线分成 n 个小端，将曲线的函数值乘以小弧段的长度，将每一段求和、取极限，如果这个极限存在，则线积分存在；

**定理**： #线积分的性质
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\int_{L(AB)}f(x,y)ds=\int_{L(BA)}f(x,y)ds$$

**解释**
+ 含义：线积分和路径的方向无关；

**推论**
+ 1.  $\int_{L_{1}+L_{2}}f(x,y)ds=\int_{L_{1}}f(x,y)ds+\int_{L_{2}}f(x,y)ds$；
+ 2. $\int_{L}[df(x,y)+\beta g(x,y)]ds=\alpha\int_{L}f(x,y)ds+\beta\int_{L}g(x,y)ds$；
+ 3. $\int_{C}f(x,y)ds=\int_{C_{1}}f(x,y)ds+\int_{C_{2}}f(x,y)ds$；
+ 4. $f(x,y)<=g(x,y) ; \int_{L}f(x,y)ds\leq\int_{L}g(x,y)ds$

### 11.1.2 曲线积分的计算
**定理**： #第一类曲线积分的计算：直接法
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>假设 L 的参数方程为 $\begin{cases}x=\varphi(t),\\y=\psi(t),&\end{cases}(\alpha\leqslant t\leqslant\beta)$，则： $$\int_{L}f(x,y)\mathrm{d}s=\int_{\alpha}^{\beta}f(\varphi(t),\psi(t))\sqrt{\varphi'(t)^2+\psi'(t)^2}\mathrm{d}t$$

**解释**
+ 注意：
	+ `ds` 是曲线的弧微分；
	+ 上下限是弧长从小到大；

**定理**： #第一类曲线积分的计算：直角方程
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\text{若 }C:y=y(x),\quad a\leq x\leq b$，则：
> $$\int_{}f(x,y)\mathrm{d}s=\int_{a}^{b}f(x,y(x))\sqrt{1+y'^2(x)}\mathrm{d}x$$

**解释**
+ 相当于把 `x` 看作为参数；

**定理**： #第一类曲线积分的计算：极坐标方程
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $\text{若 }C:\rho=\rho (\theta)\quad\alpha\leq\theta\leq\beta$，则：
> $$\int_{C}f(x,y)ds=\int_{\alpha}^{\beta}f(\rho(\theta)\cos\theta,\rho(\theta)\sin\theta)\sqrt{\rho^{2}(\theta)+\rho^{\prime2}(\theta)}d\theta $$

**定理**： #积分曲线的奇偶性
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\int_{C}f(x,y)\mathrm{d}s=\begin{cases}2\int_{C_{x>4}}f(x,y)\mathrm{d}s,&f(-x,y)=f(x,y)\\0,&f(-x,y)=-f(x,y)\end{cases}$$

**定理**： #对称性
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>一般情况：$\int_{c}f(x,y)\mathrm{d}s=\int_{c}f(y,x)\mathrm{d}s$
> 特别：$\int_Cf(x)ds=\int_Cf(y)ds$

## 11.2 第二类曲线积分 
**解释**：方法选择
+ 封闭区间：
	+ 格林公式
+ 非封闭区间：
	+ 判断：看是否与路径无关 `->` 利用偏导数是否相等
	+ 是与路径无关
		+ 改换路径 
		+ 利用原函数 
	+ 不是与路径无关
		+ 直接算方便 `->` 直接算
		+ 直接算不方便 `->` 补线格林 

### 11.2.1 基本概念
**定义**： #第二类曲线积分 
> <font color="#ccc1d9">描述：</font> $$\int_{L}P(x,y)dx+Q(x,y)dy=\lim_{\lambda\to0}\sum_{i=1}^{n}[P(\xi_{i},\eta_{i})\Delta x_{i}+Q(\xi_{i},\eta_{i})\Delta y_{i}]$$

**解释**
+ 把曲线任意划分成 n 个小端，每一个有方向的小弧段在 x 轴上的投影乘以

**性质**：曲线有方向，改变方向、变符号
+ $$\int_{L(AB)}Pdx+Qdy=-\int_{L(BA)}Pdx+Qdy$$
### 11.2.2 计算方法
**方法一：直接法**
**定理**： #第二类曲线积分的计算
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>当前参数方程为 $\begin{cases}x=\varphi(t)\\y=\psi(t)\end{cases}$，从起点 A 到终点 B 中，t 从 α 到 β：$$\int_{L}P(x,y)dx+Q(x,y)dy = \int_{\alpha}^{\beta}[p(\psi(t),\psi(t))\psi(t)+Q(\varphi(t),\psi(t))\psi^{\prime}(t)]dt$$

**解释**
+ 概念：
	+ 写出参数方程、带进去，化成定积分的计算；
+ 注意：
	+ 上下限是从起点的参数 `->` 终点的参数，而不是按照大小而来的；

**方法二：格林公式**
+ 在一个平面闭区域 `D` 的二重积分上，是否可以只求边界曲线 `L` 上值得相差，而不计算曲面上的所有点的值；
+ 这个作用由格林公式达成；

**定义**： #单连通区域 
> <font color="#ccc1d9">描述：</font>假设在 `D` 平面区域内，`D` 内任意一闭曲线围成的部分都居于 `D`；否则则称之为复连通区域；


**定理**： #格林公式
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>闭区域 `D` 上由分段光滑的曲线 `L` 围成的，$P(x,y)、Q(x,y)$ 在 `D` 上有一阶连续偏导；则：
>     $$\iint_{D}\left(\frac{\partial Q}{\partial x}-\frac{\partial P}{\partial y}\right)\mathrm{d}\sigma =\oint_{L}Pdx+Qdy$$


**解释**
+ 注意：
	+ 格林公式使用的范围 `->` 必须是在闭区域上：即曲线是封闭的；
	+ 正负方向是相对于当前区域而言的；
+ 其中：
	+ `L` 是区域 `D` 的正方向的边界曲线；

**补充**：补线用格林
+ 因为格林公式只能使用在封闭区域，因此当需要在非封闭区域使用时，可以进行补线，将非封闭区域补线为封闭区域，然后对封闭区域使用格林公式后再减去补线的部分，得到结果；

**定理**： #利用线积分与路径无关
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 
> $\text{i)判定:}\frac{\partial P}{\partial y}=\frac{\partial Q}{\partial x} (区域D单连通))$
> $ii)计算:$
> 	(a)改换路径：先改成更简单的（一般是沿着坐标轴的）的路径
> 	(b)利用原函数：$\int_{(x_{1},y_{1})}^{(x_{2},y_{2})}P\mathrm{d}x+Q\mathrm{d}y=F(x_{2},y_{2})-F(x_{1},y_{1})$
> 	求原函数的方法：1. 偏积分；2. 凑微分；

### 11.2.3 两类线积分的联系
**定理**： #两类线积分的联系
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\int_{L}P\mathbf{d}x+Q\mathbf{d}y=\int_{L}(P\cos\alpha+Q\cos\beta)\mathbf{d}s$$

### 11.2.4 计算方法：空间
#### 11.2.4.1 直接法
**定理**： #第二类曲面积分的空间计算 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $设L:x=x(t),y=y(t),z=z(t),\quad t\in[\alpha,\beta]$
> $$\int_{L}P(x,y,z)dx+Q(x,y,z)dy+R(x,y,z)dz\\=\int_{a}^{\beta}\{P[x(t),y(t),z(t)]x^{\prime}(t)+Q[x(t),y(t),z(t)]y^{\prime}(t)+\\R[x(t),y(t),z(t)]z^{\prime}(t)\}dt$$

#### 11.2.4.2 斯托克斯公式
**定理**： #斯托克斯公式 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\int_{L}P(x,y,z)\mathrm{d}x+Q(x,y,z)\mathrm{d}y+R(x,y,z)dz=$$ ![[Pasted image 20240521214413.png]]

**解释**
+ 平面时：选第一种
+ 其他时候：选第二种

## 11.3 第一类曲面积分
### 11.3.1 第一类曲面积分：对面积的曲面积分
**引例**：已知曲面构件具有连续面密度ρ(x, y, z)，求其质量 M；
+ 图示
	+ ![[Pasted image 20240212143059.png]]
+ 用每一个小面积上的密度乘以其面积，然后全部求和，得到完整的质量：$M=\lim_{\lambda\to0}\sum_{k=1}^n\rho(\xi_k,\eta_k,\zeta_k){\Delta S_k}$

**定义**： #第一类曲面积分
> <font color="#ccc1d9">描述：</font> $\text{设}\sum\text{为光滑曲面},f(x,y,z)\text{ 是定义在}\sum\text{上的一}\text{个有界函数,若对}\Sigma\text{ 做任意分割和局部区域任意取点},$ 可以得到
> 乘积和式极限：$\lim_{\lambda\to0}\sum_{k=1}^nf\left(\xi_k,\eta_k,\zeta_k\right)\Delta S_k$ 都存在，则称此极限为函数 $f(x,y,z)$ 在曲面 $\Sigma$ 上对面积的曲面积分；
> 记作：$$\iint_{\Sigma}f(x,y,z)dS=\lim_{\lambda\to0}\sum_{i=1}^{n}f(\xi_{i},\eta_{i},\zeta_{i})\Delta S_{i}$$

**解释**
+ 概念：
	+ $ds$ 相当于小曲面的面积；
	+ $f(x,y,z)$ 相当于曲面的密度；
	+ $f(x,\gamma,z)\operatorname{d}S$ 表示求一小块的质量；
	+ $\iint_{\Sigma}f(x,\gamma,z)\operatorname{d}S$ 表示对整个面上，每个小块求和极限；
	+ $\Sigma$ 称之为积分曲面；
+ 解释：
	+ 每个点的函数值，乘以这个点的小区域的面积，求和、取极限，得到对面积的面积分 `->` 和曲面的方向没关系，因为面积和方向无关系；
+ 性质：
	+ 1. 积分曲面无关性：$$\iint_{\Sigma}f(x,y,z)dS=\iint_{-\Sigma}f(x,y,z)dS$$
	+ 2. 曲面积分存在性：$若 f(x,y,z)\text{在光滑曲面}\sum\text{ 上连续}$，则对面积的曲面积分存在；
	+ 3. 对积分域的可加性：若 $\sum$ 是分片光滑的，则有：$\iint_{\Sigma}f(x,y,z)\operatorname{d}S=\iint_{\Sigma_{1}}f(x,y,z)\operatorname{d}S+\iint_{\Sigma_{2}}f(x,y,z)\operatorname{d}S$
	+ 4. 对积分的线性性质：$$\begin{aligned}\iint_{\Sigma}[k_1f(x,y,z)\pm k_2g(x,y,z)]&\operatorname{d}S=k_1\iint_{\Sigma}f(x,y,z)\operatorname{d}S\pm k_2\iint_{\Sigma}g(x,y,z)\operatorname{d}S\end{aligned}$$

### 11.3.2 对面积的曲面积分的计算
#### 11.3.2.1 直接法
**定理**： #第一类曲面积分的计算
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 有光滑曲面，其 $\Sigma:z=z(x,y),(x,y)\in D_{xy}，f(x,y,z)\text{ 在 }\sum\text{上连续}$
> 则曲面积分 $\iint_{\Sigma}f(x,y,z)dS\text{存在},\text{且有}$：
> $$\iint_{\Sigma}f(x,y,{z}){\mathrm{d}S}=\iint_{D_{xy}}f(x,y,z(x,y))\sqrt{1+{z_x}^2(x,y)+{z_y}^2(x,y)}\mathrm{d}x\mathrm{d}y$$

**解释**
+ 本质：
	+ 把**难求的曲面面积，投影成一个对 x、y 上的平面二重积分**来完成计算；
	+ 即把曲面 $\sum$ 投影到 $D_{xy}$ 上，化成 `D` 上的一个二重积分；；
	+ ${\text{若曲面由方程 }x}=x(y,z){\text{或 }\operatorname*{y}}=y(z,x)\text{ 给出,也可类似地把对面积的面积分化为相应}\text{的二重积分}$；
+ 转化：
	+ 将 z 用关于 xy 的式子带进去，得到二重积分；
+ 注意：
	+ 当出现类似 $x^2+y^2=1$ 这种中心轴为 `z` 轴的形式，则无法直接做；
	+ 此时应该使用 $y=y(x,z)$ `->` $\iint_{\Sigma}f(x,y,{z}){\mathrm{d}S}=\iint_{D_{xy}}f(x,y=y(x,z),z)\sqrt{1+{z_x}^2(x,z)+{z_z}^2(x,z)}\mathrm{d}x\mathrm{d}z$
	+ 同理对于 $x=x(y,z)$ 的形式；

#### 11.3.2.1 奇偶性与对称性
**定理**： #第一类曲面积分的奇偶性    
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>若曲面 $\sum$ 关于 $xoy$ 对称，则：
> $$\iint_{\Sigma}f(x,y,z)\mathrm{d}S=\begin{cases}2\iint_{\sum_{z>0}} f(x,y,z)\mathrm{d}S,&f(x,y,-z)=f(x,y,z)\\0&f(x,y,-z)=-f(x,y,z)\end{cases}$$


**知识点**：对称性
+ $x^2+y^2+z^2=1$ 具有很好的对称性；
+ 所以可以利用对称性简化计算： $\iint_{\Sigma}(x^2+y^2)ds=(\frac{2}{3})\iint (x^2+y^2+z^2)ds=(\frac{2}{3})\iint 1ds=\frac{2}{3}4\pi$

## 11.4 第二类曲面积分 
### 11.4.1 有向曲面及曲面元素的投影
**指定了侧的曲面，称之为有向曲面，其方向用法向量指向表示**
![[Pasted image 20240212153621.png]]
+ $\text{设 }\Sigma\text{为有向曲面},\text{其面元 }\Delta S\text{ 在 }xOy\text{ 面上的投影记为}\left(\Delta S\right)_{xy}$

### 11.4.2 第二类曲面积分：对坐标的曲面积分
**定义**： #第二类曲面积分
> <font color="#ccc1d9">描述：</font> $$\iint_{\Sigma}R(x,y,z)dxdy=\lim_{\lambda\to0}\sum_{i=1}^nR(\xi_i,\eta_i,\zeta_i)(\Delta S_i)_{xy}$$

**解释**
+ 注意：第二类曲面积分有方向
+ 概念：什么是曲面的方向
	+ 曲面的方向就是曲面侧向的方向，法向方向朝上、则侧朝上，法向方向朝下、则侧朝下；
+ 解释：
	+ 一点的函数值 $R(\xi_i,\eta_i,\zeta_i)$ 乘以它在 `xy` 上的投影： $(\Delta S_i)_{xy}$
	+ 如果是 $dxdy$ `->` 在 `xy` 上的投影；
	+ 如果是 $dzdx$ `->` 在 `xz` 上的投影；
+ 性质：与积分曲面的方向有关
	+ 改变曲面的方向，其值相反；
	+ $$\iint_{\Sigma}Pdydz+Qdzdx+Rdxdy=-\iint_{-\Sigma}Pdydz+Qdzdx+Rdxdy$$

### 11.4.3 对坐标的曲面积分的计算
#### 11.4.3.1 直接法
**定理**： #第二类曲面积分的计算
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>
> 1. $\text{设光滑曲面 }\Sigma:z=z(x,y),(x,y){\in}D_{xy}\text{ 取上侧}R(x,y,z)\text{是 }\Sigma\text{ 上的连续函数, 则}$：
> $$\iint_{\Sigma}R(x,y,z)\operatorname{d}x\operatorname{d}y=\pm\iint_{D_{xy}}R(x,y,z(x,y))\operatorname{d}x\operatorname{d}y$$
> 2. $\text{设光滑曲面 }\Sigma:x=z(y,z),(y,z){\in}D_{yz}\text{ 取上侧}R(x,y,z)\text{是 }\Sigma\text{ 上的连续函数, 则}$：
> $$\iint_{\Sigma}P(x,y,z){\mathrm{d}y\mathrm{d}z}=\pm\iint_{D_{yz}}P[x(y,z),y,z]\mathrm{d}ydz$$
> 3. $\text{设曲面: }\Sigma:y=y (z, x),\quad (z, x)\in D_{zx}$，则：$$$$

**解释**
+ 解释：
	+ 把 `dxdy` 的二型面积分，化成了 `Dxy` 投影域上的面积分；
+ 正负号的选择：
	+ 若是在 `xy` 上投影： 
		+ 上侧做积分 `->` 正号；
		+ 下侧做积分 `->` 负号；
	+ 若是在 `yz` 上投影： 
		+ `yoz` 的前侧 `->` 正号；
		+ `yoz` 的后侧 `->` 负号；
	+ 若是在 `xz` 上投影： 
		+ `xoz` 的右侧 `->` 正号；
		+ `xoz` 的左侧 `->` 负号；
+ 注意： 
	+ 若是在 `z=f(x,y)` 时：
	+ 若 `x` 为常数 `->` 投影域就是直线，此时积分就是等于 `0`；
	+ 若 `y` 为常数 `->` 投影域也是直线，此时积分也是等于 `0`；

#### 11.4.3.2 高斯公式 
**定理**： #高斯公式 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\oint\oint_{\Sigma_{\text{外}}}P\mathrm{d}y\mathrm{d}z+Q\mathrm{d}zdx+R\mathrm{d}x\mathrm{d}y=\iiint_{\Omega}\left(\frac{\partial P}{\partial x}+\frac{\partial Q}{\partial y}+\frac{\partial R}{\partial z}\right)\mathrm{d}V$$

**解释**
+ 概念： 
	+ 建立一个封闭曲面外侧的二型面积分，跟这个曲面所围成区域上空间体的三重积分的关系；
	+ 实际上，它是跟曲线积分里边的格林公式是完全类似的结论；
	+ 格林公式是建立一个平面封闭曲线的的线积分和这个封闭曲线所围成区域上二重积分的关系；

**补充**：补面用高斯公式
+ 曲面不封闭时，补一个面，使用高斯公式；
+ 然后用高斯公式计算的结果 `-` 补上的部分； 

### 11.4.4 两类曲面积分的联系 
**概念**：两类曲面积分的联系
+ 公式：$$\iint_{\Sigma}(P\cos\alpha+Q\cos\beta+R\cos\gamma)\mathrm{d}S=\iint_{\Sigma}(P\mathrm{d}y\mathrm{d}z+Q\mathrm{d}z\mathrm{d}x+R\mathrm{d}x\mathrm{d}y)$$
+ 解释： 
	+ 右端是一个二型面积分；
	+ 左端是一个一型面积分；
	+ $(\cos\alpha+\cos\beta+\cos\gamma)$ 是这一点上，曲面的法线向量的方向余弦；

# Chapter 12：行列式与矩阵
![[Pasted image 20241028005929.png]]
![[Pasted image 20241028005942.png]]
![[Pasted image 20241028010002.png]]
![[Pasted image 20241028010026.png]]
![[Pasted image 20241028010047.png]]
![[Pasted image 20241028010128.png]]
![[Pasted image 20241028010222.png]] ![[Pasted image 20241028010231.png]]
![[Pasted image 20241028010337.png]]
![[Pasted image 20241028010359.png]]
![[Pasted image 20241028010446.png]]
![[Pasted image 20241028010454.png]]

# Chapter 13：向量
![[Pasted image 20241028010547.png]] ![[Pasted image 20241028010551.png]] ![[Pasted image 20241028010559.png]] ![[Pasted image 20241028010611.png]] ![[Pasted image 20241028010617.png]]
![[Pasted image 20241028010632.png]]
![[Pasted image 20241028010648.png]]

# Chapter 14：线性方程组
![[Pasted image 20241028010708.png]]
![[Pasted image 20241028010718.png]]
![[Pasted image 20241028010727.png]]
![[Pasted image 20241028010744.png]]
![[Pasted image 20241028010754.png]]
![[Pasted image 20241028010800.png]]
![[Pasted image 20241028010812.png]]
![[Pasted image 20241028010820.png]]
![[Pasted image 20241028010847.png]]

# Chapter 15：相似
![[Pasted image 20241028010922.png]]
![[Pasted image 20241028010927.png]]
![[Pasted image 20241028010934.png]]
![[Pasted image 20241028010942.png]]
![[Pasted image 20241028010953.png]]
![[Pasted image 20241028011050.png]]

# Chapter 16：二次型
![[Pasted image 20241028011113.png]]
![[Pasted image 20241028011124.png]]
![[Pasted image 20241028011216.png]]
![[Pasted image 20241028011226.png]]
![[Pasted image 20241028011241.png]]
![[Pasted image 20241028011251.png]]

# Chapter 17：随机变量
![[Pasted image 20241029194839.png]]
![[Pasted image 20241029194946.png]]
![[Pasted image 20241029194957.png]]
![[Pasted image 20241029195005.png]]
![[Pasted image 20241029195037.png]]
![[Pasted image 20241029195044.png]]
![[Pasted image 20241029195052.png]]
![[Pasted image 20241029195105.png]]
![[Pasted image 20241029195115.png]]
![[Pasted image 20241029195125.png]]
![[Pasted image 20241029195133.png]]
![[Pasted image 20241029195149.png]]
![[Pasted image 20241029195202.png]]
![[Pasted image 20241029195216.png]]
![[Pasted image 20241029195224.png]]
![[Pasted image 20241029195233.png]]
![[Pasted image 20241029195255.png]]
![[Pasted image 20241029195313.png]]

# Chapter 18：一维随机变量
![[Pasted image 20241029195357.png]]
![[Pasted image 20241029195405.png]]
![[Pasted image 20241029195415.png]]
![[Pasted image 20241029195434.png]]
![[Pasted image 20241029195446.png]]
![[Pasted image 20241029195454.png]]
![[Pasted image 20241029195502.png]]
![[Pasted image 20241029195516.png]]
![[Pasted image 20241029195523.png]]
![[Pasted image 20241029195530.png]]
![[Pasted image 20241029195545.png]]
![[Pasted image 20241029195557.png]]
![[Pasted image 20241029195604.png]]
![[Pasted image 20241029195614.png]]
![[Pasted image 20241029195632.png]]
![[Pasted image 20241029195642.png]]
![[Pasted image 20241029195653.png]]
![[Pasted image 20241029195719.png]]
![[Pasted image 20241029195730.png]]

![[Pasted image 20241029195756.png]]

# Chapter 19：二维分布函数
![[Pasted image 20241029195844.png]]
![[Pasted image 20241029195850.png]]
![[Pasted image 20241029195857.png]]
![[Pasted image 20241029195925.png]]
![[Pasted image 20241029195932.png]]
![[Pasted image 20241029200000.png]]
![[Pasted image 20241029200010.png]]
![[Pasted image 20241029200018.png]]
![[Pasted image 20241029200031.png]]
![[Pasted image 20241029200114.png]]
![[Pasted image 20241029200122.png]]
![[Pasted image 20241029200130.png]]
![[Pasted image 20241029200136.png]]
![[Pasted image 20241029200146.png]]
![[Pasted image 20241029200153.png]]
![[Pasted image 20241029200258.png]]
![[Pasted image 20241029200308.png]]
![[Pasted image 20241029200322.png]]
![[Pasted image 20241029200328.png]]

# Chapter 20：数字特征
![[Pasted image 20241029200356.png]]
![[Pasted image 20241029200403.png]]
![[Pasted image 20241029200409.png]]
![[Pasted image 20241029200417.png]]
![[Pasted image 20241029200427.png]]
![[Pasted image 20241029200443.png]]
![[Pasted image 20241029200452.png]]
![[Pasted image 20241029200459.png]]
![[Pasted image 20241029200509.png]]
![[Pasted image 20241029200517.png]]
![[Pasted image 20241029200526.png]]
![[Pasted image 20241029200551.png]]
![[Pasted image 20241029200555.png]]
![[Pasted image 20241029200608.png]]
![[Pasted image 20241029200618.png]]
![[Pasted image 20241029200627.png]]
![[Pasted image 20241029200635.png]]
![[Pasted image 20241029200641.png]]
![[Pasted image 20241029200658.png]]
![[Pasted image 20241029200708.png]]
![[Pasted image 20241029200719.png]]
![[Pasted image 20241029200726.png]]
![[Pasted image 20241029200738.png]]

# Chapter 21：数理统计
![[Pasted image 20241029200808.png]]
![[Pasted image 20241029200818.png]]
![[Pasted image 20241029200834.png]]
![[Pasted image 20241029200842.png]]
![[Pasted image 20241029200904.png]]
![[Pasted image 20241029200918.png]]
![[Pasted image 20241029200927.png]]
![[Pasted image 20241029200939.png]]
![[Pasted image 20241029200945.png]]
![[Pasted image 20241029200955.png]]
![[Pasted image 20241029201006.png]]

# Chapter 22：参数估计与假设检验
![[Pasted image 20241029201039.png]]
![[Pasted image 20241029201102.png]]
![[Pasted image 20241029201111.png]]
![[Pasted image 20241029201117.png]]
![[Pasted image 20241029201129.png]]
![[Pasted image 20241029201143.png]]
![[Pasted image 20241029201151.png]]
![[Pasted image 20241029201157.png]]
![[Pasted image 20241029201212.png]]
![[Pasted image 20241029201226.png]]
![[Pasted image 20241029201231.png]]
![[Pasted image 20241029201238.png]]
![[Pasted image 20241029201246.png]]
![[Pasted image 20241029201254.png]]